/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing;

import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.sketch.SgroupPO;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.uif.action.manager.SimpleContext;
import chemaxon.struc.MObject;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.DataSgroup;

class SketchContext
extends SimpleContext {
    SketchContext(SketchPanel panel) {
        DataSgroup dataSgroup;
        SgroupPO sgroupPo;
        PointedObject po = panel.getEditor().getObjectForPopup();
        if (po != null) {
            this.bind(po.getContainedObject());
        }
        if ((sgroupPo = panel.getEditor().getSgroupPO()) != null) {
            this.bind(Sgroup.class, sgroupPo.getContainedObject());
        }
        if ((dataSgroup = panel.getEditor().getCurrentDataSgroup()) != null) {
            this.bind(DataSgroup.class, dataSgroup);
        }
        this.bind(MSelectionDocument.class, this.getSelectionDocument(panel));
    }

    private MSelectionDocument getSelectionDocument(SketchPanel sketchPanel) {
        if (sketchPanel.getEditor().hasSelection()) {
            return sketchPanel.getEditor().getSelectionDocument();
        }
        MSelectionDocument document = new MSelectionDocument(new SelectionMolecule());
        PointedObject po = sketchPanel.getEditor().getObjectForPopup();
        if (po == null) {
            return document;
        }
        Object o = po.getContainedObject();
        if (o instanceof MObject) {
            document.addObject((MObject)o);
        } else if (o instanceof MolBond) {
            MolBond bond = (MolBond)o;
            document.getMainMoleculeGraph().add(bond.getAtom1());
            document.getMainMoleculeGraph().add(bond.getAtom2());
            document.getMainMoleculeGraph().add(bond);
        } else if (o instanceof MolAtom) {
            document.getMainMoleculeGraph().add((MolAtom)o);
        } else if (o instanceof Sgroup) {
            Sgroup sgroup = (Sgroup)o;
            MolAtom[] atoms = sgroup.getAtomArray();
            for (int i = 0; i < atoms.length; ++i) {
                document.getMainMoleculeGraph().add(atoms[i]);
            }
        }
        return document;
    }
}

