/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.marvin.common.swing.CommonStatusBar;
import chemaxon.marvin.sketch.swing.SketchComponentFactory;
import chemaxon.marvin.sketch.swing.SketchContext;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.PluginActionStub;
import chemaxon.marvin.sketch.swing.actions.SketchPanelSetter;
import chemaxon.marvin.uif.controller.TopLevelController;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.module.ConfigurationException;
import chemaxon.marvin.uif.module.ConfigurationProvider;
import chemaxon.marvin.uif.module.GUIModule;
import chemaxon.marvin.uif.resource.IconRepository;
import chemaxon.marvin.uif.util.Utils;
import chemaxon.marvin.version.VersionInfo;
import chemaxon.util.DotfileUtil;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public final class SketchGUIModule
extends GUIModule
implements CommonStatusBar.PageActionProvider {
    private static final String PLUGIN_CATEGORY_ID = "calculation";
    private static final String DEFAULT_PERSONALIZATION_DIRECTORY = "%CHEMAXON_HOME%/%VERSION%";
    private static final String DEFAULT_MENU_RESOURCE = "SketchPanel.xml";
    private static final String DEFAULT_ACTION_RESOURCE = "SketchPanelActions.xml";
    private static final String VIEW_BUTTON_MENU_RESOURCE = "ViewButtonBarMenu.xml";
    private static final String CUSTOMIZATION_FILE = "customization.xml";
    private static final String SHURTCUT_FILE = "shortcuts.xml";
    private static final String CHEMAXON_HOME = "%CHEMAXON_HOME%";
    private static final String USER_HOME = "%USER_HOME%";
    private static final String VERSION = "%VERSION%";
    private static final String[] COMPATIBLE_VERSIONS;
    private static final Properties PROPERTIES;
    private static final String PLUGIN_PREFIX = "plugin.";
    private String menuResource = null;
    private String personalizationDirectory = null;
    private String compiledPersonalizationDirectory = null;
    private JMenuBar viewButtonMenuBar;
    private TopLevelController<JMenuBar> viewButtonMenuBarController;
    private final SketchPanel panel;
    private final ConfigurationProvider provider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties() {
        Properties properties = new Properties();
        InputStream is = SketchGUIModule.class.getResourceAsStream("SketchGUIModule.properties");
        if (is == null) {
            System.err.println("Missing resource file: SketchGUIModule.properties");
            return properties;
        }
        try {
            properties.load(is);
        }
        catch (IOException e) {
            System.err.println("Missing resource file: SketchGUIModule.properties");
        }
        finally {
            Utils.close(is);
        }
        return properties;
    }

    private static String[] parseProperties() {
        String[] versions = PROPERTIES.getProperty("compatible.versions", "").split(";");
        for (int i = 0; i < versions.length; ++i) {
            versions[i] = versions[i].trim();
        }
        return versions;
    }

    public SketchGUIModule(SketchPanel panel, String menuResource) throws ConfigurationException {
        this.setButtonFactory(new SketchComponentFactory(panel.getCanvas()));
        this.addConfigurer(new SketchPanelSetter(panel));
        this.panel = panel;
        this.menuResource = menuResource != null ? menuResource : DEFAULT_MENU_RESOURCE;
        this.provider = this.createProvider();
        this.setConfiguration(this.provider.getConfiguration(SketchPanel.class, this.menuResource, DEFAULT_ACTION_RESOURCE));
    }

    public SketchGUIModule(SketchPanel panel) throws ConfigurationException {
        this(panel, null);
    }

    private ConfigurationProvider createProvider() {
        if (DEFAULT_MENU_RESOURCE.equals(this.menuResource)) {
            return (ConfigurationProvider)SketchGUIModule.newInstance("chemaxon.marvin.uif.builder.DefaultConfigurationProvider");
        }
        return (ConfigurationProvider)SketchGUIModule.newInstance("chemaxon.marvin.sketch.swing.SimpleConfigurationProvider");
    }

    synchronized JMenuBar getViewButtonMenuBar() {
        if (this.viewButtonMenuBar == null) {
            this.viewButtonMenuBar = this.createViewButtonMenuBar();
        }
        return this.viewButtonMenuBar;
    }

    private JMenuBar createViewButtonMenuBar() {
        try {
            GUIRegistry registry = this.provider.getRegistry(SketchPanel.class, VIEW_BUTTON_MENU_RESOURCE);
            this.viewButtonMenuBarController = this.createFactory(this.getActions()).createMenuBar(registry.getMenuBar());
            return this.viewButtonMenuBarController.getComponent();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            return new JMenuBar();
        }
    }

    private FileInputStream getFileStream(File file) {
        if (file == null) {
            return null;
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e2) {
                return null;
            }
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e3) {
                return null;
            }
        }
    }

    void loadPersonalisation() throws IOException {
        FileInputStream shortcutFile;
        FileInputStream guiFile = this.getFileStream(this.getConfigFile(CUSTOMIZATION_FILE));
        if (guiFile != null) {
            this.loadGUI(guiFile);
        }
        if ((shortcutFile = this.getFileStream(this.getConfigFile(SHURTCUT_FILE))) != null) {
            this.loadShortcuts(shortcutFile);
        }
    }

    void loadPersonalisation(String configurationURL, String shortcutURL) throws IOException {
        InputStream guiIS = this.findInputStream(configurationURL);
        InputStream shortuctIS = this.findInputStream(shortcutURL);
        if (guiIS != null) {
            this.loadGUI(guiIS);
        }
        if (shortuctIS != null) {
            this.loadShortcuts(shortuctIS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void writePersonalisation() throws IOException {
        File directory = new File(this.getPersonalizationWorkDirectory());
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File guiFile = new File(directory, CUSTOMIZATION_FILE);
        File tmpGUIFile = this.createTempFile(directory, "cus");
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(tmpGUIFile));
            this.saveConfiguration(os);
            ((OutputStream)os).close();
            os = null;
            this.rename(tmpGUIFile, guiFile);
        }
        catch (Throwable throwable) {
            Utils.close(os);
            throw throwable;
        }
        Utils.close(os);
        File shortcutFile = new File(directory, SHURTCUT_FILE);
        File tmpShortcutFile = this.createTempFile(directory, "sho");
        try {
            os = new BufferedOutputStream(new FileOutputStream(tmpShortcutFile));
            this.saveShortcutConfiguration(os);
            ((OutputStream)os).close();
            os = null;
            this.rename(tmpShortcutFile, shortcutFile);
        }
        finally {
            Utils.close(os);
        }
    }

    private File createTempFile(File directory, String prefix) throws IOException {
        File result = File.createTempFile(prefix, null, directory);
        result.deleteOnExit();
        return result;
    }

    private void rename(File src, File dest) {
        if (dest.exists()) {
            dest.delete();
        }
        src.renameTo(dest);
    }

    private File getConfigFile(String fileName) {
        File result = this.getFile(fileName);
        if (result != null && result.length() == 0L) {
            result.delete();
            return null;
        }
        return result;
    }

    private File getFile(String fileName) {
        String[] dirs = this.guessPersonalizationWorkDirectory();
        for (int i = 0; i < dirs.length; ++i) {
            File result = new File(dirs[i], fileName);
            if (!result.exists()) continue;
            return result;
        }
        return null;
    }

    private InputStream findInputStream(String url) {
        if (url == null) {
            return null;
        }
        InputStream result = BasicEnvironment.getResourceAsStream(SketchPanel.class, url);
        if (result == null) {
            result = Utils.getInputStream(url);
        }
        return result;
    }

    private void loadShortcuts(InputStream input) throws IOException, FileNotFoundException {
        BufferedInputStream is = new BufferedInputStream(input);
        this.loadShortcutConfiguration(is);
        Utils.close(is);
    }

    @Override
    public synchronized JPopupMenu showPopup(String id, MouseEvent e) {
        return super.showPopup(id, new SketchContext(this.panel), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGUI(InputStream input) throws IOException {
        BufferedInputStream is = new BufferedInputStream(input);
        try {
            this.loadConfiguration(is);
        }
        finally {
            Utils.close(is);
        }
    }

    private String[] guessPersonalizationWorkDirectory() {
        String directory = this.getCompiledPersonalizationDirectory();
        if (!directory.contains(VERSION)) {
            return new String[]{directory};
        }
        String[] result = new String[COMPATIBLE_VERSIONS.length + 1];
        result[0] = this.getPersonalizationWorkDirectory();
        for (int i = 0; i < COMPATIBLE_VERSIONS.length; ++i) {
            result[i + 1] = SketchGUIModule.getWorkDirectory(directory, COMPATIBLE_VERSIONS[i]);
        }
        return result;
    }

    private String getCompiledPersonalizationDirectory() {
        if (this.compiledPersonalizationDirectory == null) {
            String directory = this.getPersonalizationDirectory();
            directory = directory.replaceAll(USER_HOME, Matcher.quoteReplacement(System.getProperty("user.home")));
            directory = directory.replaceAll(CHEMAXON_HOME, Matcher.quoteReplacement(DotfileUtil.getDotDir().getPath()));
            this.compiledPersonalizationDirectory = directory = directory.replaceAll("/", Matcher.quoteReplacement(File.separator));
        }
        return this.compiledPersonalizationDirectory;
    }

    private static String getWorkDirectory(String path, String version) {
        return path.replaceAll(VERSION, Matcher.quoteReplacement(version.replace(File.separatorChar, '-')));
    }

    private String getPersonalizationWorkDirectory() {
        return SketchGUIModule.getWorkDirectory(this.getCompiledPersonalizationDirectory(), VersionInfo.MARVIN_VERSION);
    }

    void setPersonalizationDirectory(String directory) {
        this.personalizationDirectory = directory;
    }

    private String getPersonalizationDirectory() {
        return this.personalizationDirectory != null ? this.personalizationDirectory : DEFAULT_PERSONALIZATION_DIRECTORY;
    }

    @Override
    protected void actionsLoaded() {
        Icon icon;
        if (this.panel.getParameter("transferButtonText") != null) {
            this.getActions().getActionFace("transfer", "toolbar").setName(this.panel.getParameter("transferButtonText"));
        }
        if (this.panel.getParameter("transferButtonIcon") != null && (icon = IconRepository.getIcon(this.panel.getParameter("transferButtonIcon"))) != null) {
            this.getActions().getActionFace("transfer", "toolbar").setSmallIcon(icon);
            this.getActions().getActionFace("transfer", "toolbar").setLargeIcon(icon);
        }
        this.getActions().getAction("lassoSelectMode").isEnabled();
        this.registerPluginActions();
    }

    private void registerPluginActions() {
        for (String id : PROPERTIES.stringPropertyNames()) {
            if (!id.startsWith(PLUGIN_PREFIX)) continue;
            this.getActions().register(id, PLUGIN_CATEGORY_ID, new PluginActionStub(this.panel, PROPERTIES.getProperty(id)));
        }
    }

    public void populateHelpMenu(Container container) {
        this.addMenuItem(container, "helpContents", true);
        this.addMenuItem(container, "licenses", true);
        this.addMenuItem(container, "about", false);
    }

    private void addMenuItem(Container container, String id, boolean separator) {
        Action action = this.getActions().getAction(id);
        if (action != null) {
            container.add(new JMenuItem());
            if (separator) {
                container.add(new JSeparator());
            }
        }
    }

    @Override
    public Action getFirstPageAction() {
        return this.getActions().getAction("firstPage");
    }

    @Override
    public Action getGoToPageAction() {
        return this.getActions().getAction("gotoPage");
    }

    @Override
    public Action getLastPageAction() {
        return this.getActions().getAction("lastPage");
    }

    @Override
    public Action getNextPageAction() {
        return this.getActions().getAction("nextPage");
    }

    @Override
    public Action getPreviousPageAction() {
        return this.getActions().getAction("previousPage");
    }

    static {
        PROPERTIES = SketchGUIModule.loadProperties();
        COMPATIBLE_VERSIONS = SketchGUIModule.parseProperties();
    }
}

