/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing;

import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import chemaxon.marvin.sketch.AbstractSelectSM;
import chemaxon.marvin.sketch.AtomSM;
import chemaxon.marvin.sketch.BondSM;
import chemaxon.marvin.sketch.KeyboardInput;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.MoleculeSM;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.sketch.swing.MObjectEditor;
import chemaxon.marvin.sketch.swing.SketchCanvas;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.TextEditor;
import chemaxon.marvin.sketch.swing.actions.ZoomModel;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.Molecule;
import chemaxon.struc.graphics.MTextBox;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public class SketchKeyBindings {
    SketchCanvas sketchCanvas;
    SketchPanel sketchPanel;
    KeyboardInput keyboardInput;
    MObjectEditor textBoxEditor;
    TextEditor textEditor;
    boolean consumed = false;
    InputMap boxInputMap;
    private int previousDirectionX = 0;
    private int previousDirectionY = 0;

    public SketchKeyBindings(SketchPanel skpan, KeyboardInput keyin, MObjectEditor editor) {
        this.sketchPanel = skpan;
        this.sketchCanvas = skpan.getCanvas();
        this.keyboardInput = keyin;
        this.setTextBoxEditor(editor);
        this.initKeyMap();
    }

    public void setTextBoxEditor(MObjectEditor editor) {
        this.textBoxEditor = editor;
        if (editor instanceof TextEditor) {
            this.textEditor = (TextEditor)((Object)editor);
        }
    }

    void initTextBoxKeyMap() {
        this.boxInputMap = new InputMap();
        this.boxInputMap.put(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "textboxcopy");
        this.boxInputMap.put(KeyStroke.getKeyStroke(155, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "textboxcopy");
        this.boxInputMap.put(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "textboxpaste");
        this.boxInputMap.put(KeyStroke.getKeyStroke(155, 64), "textboxpaste");
        this.boxInputMap.put(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "textboxcut");
        this.boxInputMap.put(KeyStroke.getKeyStroke(36, 0), "home");
        this.boxInputMap.put(KeyStroke.getKeyStroke(36, 64), "shifthome");
        this.boxInputMap.put(KeyStroke.getKeyStroke(36, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "controlhome");
        this.boxInputMap.put(KeyStroke.getKeyStroke(36, 0x40 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "controlshifthome");
        this.boxInputMap.put(KeyStroke.getKeyStroke(35, 0), "end");
        this.boxInputMap.put(KeyStroke.getKeyStroke(35, 64), "shiftend");
        this.boxInputMap.put(KeyStroke.getKeyStroke(35, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "controlend");
        this.boxInputMap.put(KeyStroke.getKeyStroke(35, 0x40 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "controlshiftend");
        this.boxInputMap.put(KeyStroke.getKeyStroke(38, 0), "up");
        this.boxInputMap.put(KeyStroke.getKeyStroke(38, 64), "shiftup");
        this.boxInputMap.put(KeyStroke.getKeyStroke(40, 0), "down");
        this.boxInputMap.put(KeyStroke.getKeyStroke(40, 64), "shiftdown");
        this.boxInputMap.put(KeyStroke.getKeyStroke(39, 0), "right");
        this.boxInputMap.put(KeyStroke.getKeyStroke(39, 64), "shiftright");
        this.boxInputMap.put(KeyStroke.getKeyStroke(37, 0), "left");
        this.boxInputMap.put(KeyStroke.getKeyStroke(37, 64), "shiftleft");
        this.boxInputMap.put(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "boldfont");
        this.boxInputMap.put(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "italicfont");
        this.boxInputMap.put(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "selectall");
        this.sketchCanvas.getActionMap().put("textboxcopy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SketchKeyBindings.this.keyboardInput.insertChar(true)) {
                    SketchKeyBindings.this.copyInTextBox();
                    SketchKeyBindings.this.keyboardInput.clear();
                }
                SketchKeyBindings.this.consumed(true);
            }
        });
        this.sketchCanvas.getActionMap().put("textboxpaste", new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                boolean histEnabled = SketchKeyBindings.this.sketchPanel.getEditor().setHistorizeEnabled(false);
                try {
                    SketchKeyBindings.this.pasteInTextBox(SketchKeyBindings.this.sketchPanel.getEditor().getFocusedMTextBox());
                }
                finally {
                    SketchKeyBindings.this.sketchPanel.getEditor().setHistorizeEnabled(histEnabled);
                    SketchKeyBindings.this.sketchPanel.getEditor().historize();
                    SketchKeyBindings.this.sketchPanel.setScrollbars(true);
                    SketchKeyBindings.this.sketchCanvas.repaint();
                    SketchKeyBindings.this.consumed(true);
                }
            }
        });
        this.sketchCanvas.getActionMap().put("textboxcut", new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                boolean histEnabled = SketchKeyBindings.this.sketchPanel.getEditor().setHistorizeEnabled(false);
                try {
                    if (SketchKeyBindings.this.keyboardInput.deleteChar(true)) {
                        SketchKeyBindings.this.copyInTextBox();
                        SketchKeyBindings.this.keyboardInput.clear();
                    } else {
                        SketchKeyBindings.this.keyboardInput.add('\u007f', SketchKeyBindings.this.sketchPanel);
                    }
                }
                finally {
                    SketchKeyBindings.this.sketchPanel.getEditor().setHistorizeEnabled(histEnabled);
                    SketchKeyBindings.this.sketchPanel.getEditor().historize();
                    SketchKeyBindings.this.sketchPanel.setScrollbars(true);
                    SketchKeyBindings.this.sketchCanvas.repaint();
                    SketchKeyBindings.this.consumed(true);
                }
            }
        });
        this.sketchCanvas.getActionMap().put("selectall", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.keyboardInput.cursorHome(false);
                SketchKeyBindings.this.keyboardInput.cursorEnd(true);
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.handleKeyType();
                SketchKeyBindings.this.consumed(true);
            }
        });
        this.sketchCanvas.getActionMap().put("home", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.keyboardInput.cursorToRowStart(false);
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.handleKeyType();
            }
        });
        this.sketchCanvas.getActionMap().put("shifthome", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.keyboardInput.cursorToRowStart(true);
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.handleKeyType();
            }
        });
        this.sketchCanvas.getActionMap().put("controlhome", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.keyboardInput.cursorHome(false);
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.handleKeyType();
            }
        });
        this.sketchCanvas.getActionMap().put("controlshifthome", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.keyboardInput.cursorHome(true);
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.handleKeyType();
            }
        });
        this.sketchCanvas.getActionMap().put("end", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SketchKeyBindings.this.keyboardInput.cursorToRowEnd(false)) {
                    SketchKeyBindings.this.keyboardInput.complete();
                }
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.handleKeyType();
            }
        });
        this.sketchCanvas.getActionMap().put("shiftend", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SketchKeyBindings.this.keyboardInput.cursorToRowEnd(true)) {
                    SketchKeyBindings.this.keyboardInput.complete();
                }
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.handleKeyType();
            }
        });
        this.sketchCanvas.getActionMap().put("controlend", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SketchKeyBindings.this.keyboardInput.cursorEnd(false)) {
                    SketchKeyBindings.this.keyboardInput.complete();
                }
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.handleKeyType();
            }
        });
        this.sketchCanvas.getActionMap().put("controlshiftend", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SketchKeyBindings.this.keyboardInput.cursorEnd(true)) {
                    SketchKeyBindings.this.keyboardInput.complete();
                }
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.handleKeyType();
            }
        });
        this.sketchCanvas.getActionMap().put("up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.keyboardInput.cursorUp(false);
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.handleKeyType();
            }
        });
        this.sketchCanvas.getActionMap().put("shiftup", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.keyboardInput.cursorUp(true);
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.handleKeyType();
            }
        });
        this.sketchCanvas.getActionMap().put("down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.keyboardInput.cursorDown(false);
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.handleKeyType();
            }
        });
        this.sketchCanvas.getActionMap().put("shiftdown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.keyboardInput.cursorDown(true);
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.handleKeyType();
            }
        });
        this.sketchCanvas.getActionMap().put("right", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.keyboardInput.cursorRight(false);
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.handleKeyType();
            }
        });
        this.sketchCanvas.getActionMap().put("shiftright", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.keyboardInput.cursorRight(true);
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.handleKeyType();
            }
        });
        this.sketchCanvas.getActionMap().put("left", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.keyboardInput.cursorLeft(false);
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.handleKeyType();
            }
        });
        this.sketchCanvas.getActionMap().put("shiftleft", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.keyboardInput.cursorLeft(true);
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.handleKeyType();
            }
        });
        this.sketchCanvas.getActionMap().put("boldfont", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.textEditor.setBoldFont(!SketchKeyBindings.this.textEditor.isBoldFont());
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.sketchCanvas.repaint();
            }
        });
        this.sketchCanvas.getActionMap().put("italicfont", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.textEditor.setItalicFont(!SketchKeyBindings.this.textEditor.isItalicFont());
                SketchKeyBindings.this.updateTextBoxEditor();
                SketchKeyBindings.this.sketchCanvas.repaint();
            }
        });
    }

    void initKeyMap() {
        int type = 0;
        this.initTextBoxKeyMap();
        SketchInputMap sketchInputMap = new SketchInputMap();
        sketchInputMap.setParent(this.sketchCanvas.getInputMap(type));
        this.sketchCanvas.setFocusable(true);
        this.sketchCanvas.setFocusTraversalKeysEnabled(false);
        this.sketchCanvas.setInputMap(type, sketchInputMap);
        sketchInputMap.put(KeyStroke.getKeyStroke(40, 64), "shiftdownarrow");
        sketchInputMap.put(KeyStroke.getKeyStroke(38, 64), "shiftuparrow");
        sketchInputMap.put(KeyStroke.getKeyStroke(37, 64), "shiftleftarrow");
        sketchInputMap.put(KeyStroke.getKeyStroke(39, 64), "shiftrightarrow");
        sketchInputMap.put(KeyStroke.getKeyStroke(40, 0), "downarrow");
        sketchInputMap.put(KeyStroke.getKeyStroke(38, 0), "uparrow");
        sketchInputMap.put(KeyStroke.getKeyStroke(37, 0), "leftarrow");
        sketchInputMap.put(KeyStroke.getKeyStroke(39, 0), "rightarrow");
        sketchInputMap.put(KeyStroke.getKeyStroke(40, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "controldownarrow");
        sketchInputMap.put(KeyStroke.getKeyStroke(38, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "controluparrow");
        sketchInputMap.put(KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "controlleftarrow");
        sketchInputMap.put(KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "controlrightarrow");
        sketchInputMap.put(KeyStroke.getKeyStroke(27, 0), "escape");
        sketchInputMap.put(KeyStroke.getKeyStroke(10, 0), "enter");
        sketchInputMap.put(KeyStroke.getKeyStroke(9, 0), "texttab");
        sketchInputMap.put(KeyStroke.getKeyStroke(127, 0), "delete");
        sketchInputMap.put(KeyStroke.getKeyStroke(127, 64), "shiftdelete");
        sketchInputMap.put(KeyStroke.getKeyStroke(33, 0), "pageup");
        sketchInputMap.put(KeyStroke.getKeyStroke(34, 0), "pagedown");
        sketchInputMap.put(KeyStroke.getKeyStroke(16, 64, false), "shiftmodifier");
        sketchInputMap.put(KeyStroke.getKeyStroke(16, 0, true), "shiftmodifier");
        this.sketchCanvas.getActionMap().put("shiftmodifier", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int mask;
                int mod = e.getModifiers();
                int oldmod = SketchKeyBindings.this.sketchPanel.getEditor().getModifiers();
                if ((oldmod & (mask = 11)) != (mod & mask)) {
                    SketchMode sm = SketchKeyBindings.this.sketchPanel.getEditor().getSketchMode();
                    if (sm instanceof MoleculeSM || sm instanceof AtomSM || sm instanceof BondSM || sm instanceof AbstractSelectSM) {
                        if (SketchKeyBindings.this.sketchPanel.getEditor().command(8, mod) != 0) {
                            SketchKeyBindings.this.sketchPanel.repaint();
                        }
                    } else if (SketchKeyBindings.this.sketchPanel.getEditor().command(8, mod & mask) != 0) {
                        SketchKeyBindings.this.sketchPanel.repaint();
                    }
                }
            }
        });
        this.sketchCanvas.getActionMap().put("shiftdownarrow", new MoveAction(Direction.DOWN, true));
        this.sketchCanvas.getActionMap().put("shiftuparrow", new MoveAction(Direction.UP, true));
        this.sketchCanvas.getActionMap().put("shiftleftarrow", new MoveAction(Direction.LEFT, true));
        this.sketchCanvas.getActionMap().put("shiftrightarrow", new MoveAction(Direction.RIGHT, true));
        this.sketchCanvas.getActionMap().put("controldownarrow", new ScrollAction(Direction.DOWN));
        this.sketchCanvas.getActionMap().put("controluparrow", new ScrollAction(Direction.UP));
        this.sketchCanvas.getActionMap().put("controlleftarrow", new ScrollAction(Direction.LEFT));
        this.sketchCanvas.getActionMap().put("controlrightarrow", new ScrollAction(Direction.RIGHT));
        this.sketchCanvas.getActionMap().put("downarrow", new MoveAction(Direction.DOWN, false));
        this.sketchCanvas.getActionMap().put("uparrow", new MoveAction(Direction.UP, false));
        this.sketchCanvas.getActionMap().put("leftarrow", new MoveAction(Direction.LEFT, false));
        this.sketchCanvas.getActionMap().put("rightarrow", new MoveAction(Direction.RIGHT, false));
        this.sketchCanvas.getActionMap().put("delete", new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                boolean histEnabled = SketchKeyBindings.this.sketchPanel.getEditor().setHistorizeEnabled(false);
                try {
                    SketchKeyBindings.this.handleDelete(false);
                }
                finally {
                    SketchKeyBindings.this.sketchPanel.getEditor().setHistorizeEnabled(histEnabled);
                    SketchKeyBindings.this.sketchPanel.getEditor().historize();
                    SketchKeyBindings.this.sketchPanel.setScrollbars(true);
                    SketchKeyBindings.this.sketchCanvas.repaint();
                    SketchKeyBindings.this.consumed(true);
                }
            }
        });
        this.sketchCanvas.getActionMap().put("shiftdelete", new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                boolean histEnabled = SketchKeyBindings.this.sketchPanel.getEditor().setHistorizeEnabled(false);
                try {
                    SketchKeyBindings.this.handleDelete(true);
                }
                finally {
                    SketchKeyBindings.this.sketchPanel.getEditor().setHistorizeEnabled(histEnabled);
                    SketchKeyBindings.this.sketchPanel.getEditor().historize();
                    SketchKeyBindings.this.sketchPanel.setScrollbars(true);
                    SketchKeyBindings.this.sketchCanvas.repaint();
                    SketchKeyBindings.this.consumed(true);
                }
            }
        });
        this.sketchCanvas.getActionMap().put("texttab", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.keyboardInput.add('\t', SketchKeyBindings.this.sketchPanel);
                SketchKeyBindings.this.handleKeyType();
            }
        });
        this.sketchCanvas.getActionMap().put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.sketchCanvas.reset();
                SketchKeyBindings.this.keyboardInput.clear();
                SketchKeyBindings.this.sketchPanel.pressButton(false);
            }
        });
        this.sketchCanvas.getActionMap().put("enter", new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                boolean histEnabled = SketchKeyBindings.this.sketchPanel.getEditor().setHistorizeEnabled(false);
                try {
                    if (!SketchKeyBindings.this.keyboardInput.enter()) {
                        if (SketchKeyBindings.this.keyboardInput.isUnfinishedButCompletionPossible()) {
                            SketchKeyBindings.this.keyboardInput.complete();
                            SketchKeyBindings.this.handleKeyType();
                        } else {
                            SketchKeyBindings.this.keyboardInput.clear();
                            SketchKeyBindings.this.sketchCanvas.repaintKeyinString();
                        }
                    } else {
                        SketchKeyBindings.this.handleKeyType();
                    }
                }
                finally {
                    SketchKeyBindings.this.sketchPanel.getEditor().setHistorizeEnabled(histEnabled);
                    SketchKeyBindings.this.sketchPanel.getEditor().historize();
                    SketchKeyBindings.this.sketchPanel.setScrollbars(true);
                    SketchKeyBindings.this.sketchCanvas.repaint();
                }
            }
        });
        this.sketchCanvas.getActionMap().put("pageup", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.sketchPanel.pageUp();
                SketchKeyBindings.this.consumed(true);
            }
        });
        this.sketchCanvas.getActionMap().put("pagedown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchKeyBindings.this.sketchPanel.pageDown();
                SketchKeyBindings.this.consumed(true);
            }
        });
        this.sketchCanvas.getActionMap().put("keytype", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SketchKeyBindings.this.consumed) {
                    SketchKeyBindings.this.consumed(false);
                    return;
                }
                String content = e.getActionCommand();
                int mod = e.getModifiers();
                if (content != null && content.length() > 0 && (mod & 8) == (mod & 2)) {
                    SketchKeyBindings.this.keyboardInput.add(content.charAt(0), SketchKeyBindings.this.sketchPanel);
                    SketchKeyBindings.this.handleKeyType();
                }
            }
        });
    }

    private void consumed(boolean b) {
        this.consumed = b;
    }

    private void handleDelete(boolean shift) {
        if (shift) {
            if (this.keyboardInput.deleteChar(true)) {
                this.updateTextBoxEditor();
                this.copyInTextBox();
                this.sketchCanvas.repaint();
            }
        } else if (this.keyboardInput.deleteChar(false)) {
            this.updateTextBoxEditor();
            this.sketchCanvas.repaint();
        } else {
            this.keyboardInput.add('\u007f', this.sketchPanel);
            this.updateTextBoxEditor();
            this.handleKeyType();
        }
    }

    private void handleKeyType() {
        DPoint3 ptrPos = this.sketchCanvas.getPointerPos();
        SketchMode so = this.keyboardInput.getSketchMode();
        int tmpl = this.keyboardInput.getTemplateNumber();
        if (so != null) {
            Molecule m = so.getMol();
            if (m == null || this.sketchPanel.getEditor().isAllowed(m)) {
                so.moveTo(ptrPos);
                this.sketchPanel.pressButton(so, false);
            }
        } else if (tmpl <= 0) {
            this.sketchCanvas.repaint();
            this.sketchCanvas.repaintKeyinString();
        }
    }

    private void updateTextBoxEditor() {
        MolEditor med = this.sketchCanvas.getEditor();
        if (this.textBoxEditor != null && med.getFocusedMTextBox() != null) {
            this.textBoxEditor.update();
        }
    }

    private boolean copyInTextBox() {
        String s = this.keyboardInput.getTemporaryTextClipboardContents();
        if (s != null) {
            ClipboardHandler.putStringToClipboard(s);
            return true;
        }
        return false;
    }

    private boolean pasteInTextBox(MTextBox t) {
        if (t != null) {
            String s = ClipboardHandler.getStringFromClipboard();
            if (s != null) {
                t.addString(s);
                return true;
            }
            this.sketchCanvas.reset();
        }
        return false;
    }

    private void move(Direction direction, boolean largeMove) {
        List<MObject> objlist = this.sketchCanvas.getEditor().getSelectionDocument().getAllObjects();
        CTransform3D transform = new CTransform3D();
        CTransform3D view = new CTransform3D();
        view.set(this.sketchCanvas.getPainter().getTransformMatrix());
        CTransform3D viewInverse = new CTransform3D();
        viewInverse.set(view);
        viewInverse.invert();
        CTransform3D translation = new CTransform3D();
        double moveDiffUnit = new ZoomModel(this.sketchPanel).getNormalizedScale() * 1.54 * 0.18 / (double)(largeMove ? 1 : 30);
        translation.setTranslation((double)direction.getDx() * moveDiffUnit, (double)direction.getDy() * moveDiffUnit, 0.0);
        transform.mul(viewInverse);
        transform.mul(translation);
        transform.mul(view);
        for (MObject current : objlist) {
            if (!current.isTransformable()) continue;
            current.transform(transform, 0, null);
        }
        this.sketchPanel.setScrollbars(false);
    }

    private void scroll(Direction direction, boolean scrollOnly, boolean historize) {
        int scrollSpeed = scrollOnly ? 10 : 1;
        this.sketchPanel.scrollCanvas(this.sketchPanel.getHScrollBarPos() + scrollSpeed * direction.getDx(), this.sketchPanel.getVScrollBarPos() + scrollSpeed * direction.getDy(), false, historize);
        this.consumed(false);
    }

    private class SketchInputMap
    extends InputMap {
        private SketchInputMap() {
        }

        @Override
        public Object get(KeyStroke keyStroke) {
            Object ret;
            Object boxResult;
            Object result = super.get(keyStroke);
            MTextBox box = SketchKeyBindings.this.sketchPanel.getEditor().getFocusedMTextBox();
            if (box != null && (boxResult = SketchKeyBindings.this.boxInputMap.get(keyStroke)) != null) {
                return boxResult;
            }
            Object object = ret = result != null || keyStroke.getKeyChar() == '\uffff' ? result : "keytype";
            if (ret != null && ret.equals("keytype") && keyStroke.getKeyChar() != '\b' && keyStroke.getKeyChar() < '\u001f') {
                ret = null;
            }
            return ret;
        }
    }

    private final class ScrollAction
    extends AbstractAction {
        private final Direction direction;

        public ScrollAction(Direction direction) {
            this.direction = direction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SketchKeyBindings.this.scroll(this.direction, true, false);
        }
    }

    private final class MoveAction
    extends AbstractAction {
        private final Direction direction;
        private final boolean largeMove;

        public MoveAction(Direction direction, boolean largeMove) {
            this.direction = direction;
            this.largeMove = largeMove;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean historize;
            if (!SketchKeyBindings.this.sketchCanvas.getEditor().hasSelection() || SketchKeyBindings.this.sketchCanvas.getEditor().isAllSelected()) {
                SketchKeyBindings.this.scroll(this.direction, true, false);
                return;
            }
            boolean bl = historize = SketchKeyBindings.this.sketchCanvas.getEditor().isNewKeyboardMotion() || SketchKeyBindings.this.previousDirectionX != this.direction.dx || SketchKeyBindings.this.previousDirectionY != this.direction.dy;
            if (historize && !SketchKeyBindings.this.sketchCanvas.getEditor().isNewKeyboardMotion()) {
                boolean hist = SketchKeyBindings.this.sketchCanvas.getEditor().setHistorizeEnabled(true);
                SketchKeyBindings.this.sketchCanvas.getEditor().historize();
                SketchKeyBindings.this.sketchCanvas.getEditor().setHistorizeEnabled(hist);
            }
            SketchKeyBindings.this.move(this.direction, this.largeMove);
            SketchKeyBindings.this.previousDirectionX = this.direction.dx;
            SketchKeyBindings.this.previousDirectionY = this.direction.dy;
            SketchKeyBindings.this.sketchCanvas.getEditor().setNewKeyboardMotion(false);
        }
    }

    private static enum Direction {
        UP(0, -1),
        DOWN(0, 1),
        LEFT(-1, 0),
        RIGHT(1, 0);

        private final int dx;
        private final int dy;

        private Direction(int dx, int dy) {
            this.dx = dx;
            this.dy = dy;
        }

        public int getDx() {
            return this.dx;
        }

        public int getDy() {
            return this.dy;
        }
    }
}

