/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.marvin.sketch.swing.ClassLoaderTask;
import chemaxon.marvin.util.MarvinModule;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;

public class SketchModuleLoaderTask
implements Runnable {
    private static final String MODULES_PROPERTIES = "/chemaxon/marvin/sketch/modules.properties";
    private static Properties mprops = new Properties();
    private static Collection<String> defaultModulesLoadedBackground = new Vector<String>();
    private String moduleName;

    public SketchModuleLoaderTask(String moduleName) {
        this.moduleName = moduleName;
    }

    public static String getModuleByNickname(String nick) {
        return mprops.getProperty(nick);
    }

    public static Collection<String> getModules() {
        Vector<String> array = new Vector<String>();
        for (Object o : mprops.values()) {
            array.add(o.toString());
        }
        return array;
    }

    public static Collection<String> getDefaultModulesLoadedBackground() {
        return defaultModulesLoadedBackground;
    }

    public static Runnable getTask(String modname) {
        if (modname == null || modname.equals("")) {
            return null;
        }
        if (modname.endsWith(".class")) {
            String classname = modname.substring(0, modname.length() - ".class".length());
            if (classname.equals("")) {
                return null;
            }
            return new ClassLoaderTask(classname);
        }
        return new SketchModuleLoaderTask(modname);
    }

    public String toString() {
        return "SketchModuleLoaderTask[" + this.moduleName + "]";
    }

    @Override
    public void run() {
        MarvinModule.load(this.moduleName, null);
    }

    static {
        InputStream is = BasicEnvironment.getResourceAsStream(SketchModuleLoaderTask.class, MODULES_PROPERTIES);
        if (is != null) {
            try {
                mprops.load(is);
                for (Object o : mprops.keySet()) {
                    String value = mprops.get(o).toString();
                    if (value.indexOf(59) <= -1) continue;
                    value = value.substring(0, value.indexOf(59));
                    mprops.put(o, value);
                    defaultModulesLoadedBackground.add(value);
                }
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        } else {
            System.err.println("Cannot access /chemaxon/marvin/sketch/modules.properties");
        }
    }
}

