/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions;

import chemaxon.marvin.sketch.AtomPO;
import chemaxon.marvin.sketch.BondPO;
import chemaxon.marvin.sketch.MObjectPO;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.SgroupPO;
import chemaxon.marvin.sketch.swing.SketchCanvas;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.SketchPanelAware;
import chemaxon.marvin.uif.action.Context;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import javax.swing.AbstractAction;
import javax.swing.Action;

public abstract class AbstractSketchAction
extends AbstractAction
implements SketchPanelAware {
    private SketchPanel panel;

    public AbstractSketchAction(SketchPanel panel) {
        this.panel = panel;
        this.update();
    }

    public AbstractSketchAction() {
        this((SketchPanel)null);
    }

    @Override
    public void setSketchPanel(SketchPanel panel) {
        this.panel = panel;
        this.update();
    }

    protected final MolBond getSelectedBond() {
        Object selected = this.getSelectedObject();
        return selected instanceof BondPO ? ((BondPO)selected).getBond() : null;
    }

    protected final MolAtom getSelectedAtom() {
        return this.getSelectedAtom(true);
    }

    protected final MolAtom getSelectedAtom(boolean filter) {
        MolAtom result;
        Object selected = this.getSelectedObject();
        MolAtom molAtom = result = selected instanceof AtomPO ? ((AtomPO)selected).getAtom() : null;
        if (filter) {
            result = AbstractSketchAction.filterAtom(result);
        }
        return result;
    }

    private static MolAtom filterAtom(MolAtom result) {
        if (result != null && result.getAtno() == 137 || AbstractSketchAction.isSGroupAtom(result)) {
            return null;
        }
        return result;
    }

    protected final Sgroup getSelectedSGroup() {
        if (this.getEditor() == null) {
            return null;
        }
        SgroupPO pointer = this.getEditor().getSgroupPOForMenu();
        if (pointer == null) {
            return null;
        }
        Sgroup group = pointer.getSgroup();
        return AbstractSketchAction.filterSgroup(group);
    }

    private static Sgroup filterSgroup(Sgroup group) {
        return group instanceof MulticenterSgroup || group instanceof DataSgroup ? null : group;
    }

    protected final MObject getSelectedMObject() {
        MObject result;
        Object selected = this.getSelectedObject();
        MObject mObject = result = selected instanceof MObjectPO ? ((MObjectPO)selected).getMObject() : null;
        if (result != null && result.isInternalSelectable()) {
            result = this.getEditor().getContainerMObject(result);
        }
        return result;
    }

    protected final DataSgroup getSelectedDataSGroup() {
        return this.getEditor().getSelectedDataSgroup();
    }

    private Object getSelectedObject() {
        if (this.getPanel() == null) {
            return null;
        }
        MolEditor editor = this.getEditor();
        if (!editor.hasSelection()) {
            return null;
        }
        return editor.getObjectForMenu();
    }

    private void update() {
        this.setEnabled(this.panel != null);
    }

    protected final SketchPanel getPanel() {
        return this.panel;
    }

    protected final SketchCanvas getCanvas() {
        if (this.getPanel() == null) {
            return null;
        }
        return this.getPanel().getCanvas();
    }

    protected final MolEditor getEditor() {
        return this.panel != null ? this.panel.getEditor() : null;
    }

    protected final MSelectionDocument getSelectionDocument() {
        return this.getEditor().getSelectionDocument();
    }

    protected final MoleculeGraph getSelectionMolecule() {
        return this.getSelectionDocument().getMainMoleculeGraph();
    }

    protected final MDocument getDocument() {
        return this.getEditor() != null ? this.getEditor().getDocument() : null;
    }

    public static boolean isRGroup(MolAtom atom) {
        return atom != null && atom.getAtno() == 134;
    }

    public static boolean isSGroupAtom(MolAtom atom) {
        return atom instanceof SgroupAtom;
    }

    public static boolean isGroup(MolAtom atom) {
        return AbstractSketchAction.isRGroup(atom) || AbstractSketchAction.isSGroupAtom(atom);
    }

    public static boolean isLP(MolAtom atom) {
        return atom != null && atom.getAtno() == 130;
    }

    public static boolean isNormalAtom(MolAtom atom) {
        return atom != null && !AbstractSketchAction.isGroup(atom) && !AbstractSketchAction.isLP(atom);
    }

    public static boolean isMulticenter(MolAtom atom) {
        return atom != null && atom.getAtno() == 137;
    }

    protected boolean isRgroupAttachmentPoint(MolAtom atom) {
        return atom != null && atom.getAtno() == 138;
    }

    protected static MolAtom lookupAtom(Context context, boolean filter) {
        MolAtom atom = context.lookup(MolAtom.class);
        return filter ? AbstractSketchAction.filterAtom(atom) : atom;
    }

    protected static MolAtom lookupAtom(Context context) {
        return AbstractSketchAction.lookupAtom(context, true);
    }

    protected static MolBond lookupBond(Context context) {
        return context.lookup(MolBond.class);
    }

    protected static MObject lookupMObject(Context context) {
        return context.lookup(MObject.class);
    }

    protected static DataSgroup lookupDataSgroup(Context context) {
        return context.lookup(DataSgroup.class);
    }

    protected static Sgroup lookupSGroup(Context context) {
        return AbstractSketchAction.filterSgroup(context.lookup(Sgroup.class));
    }

    protected static MSelectionDocument lookupSelectionDocument(Context context) {
        return context.lookup(MSelectionDocument.class);
    }

    protected final MoleculeGraph lookupgetSelectionMolecule(Context context) {
        MSelectionDocument document = AbstractSketchAction.lookupSelectionDocument(context);
        if (document == null) {
            return null;
        }
        return document.getMainMoleculeGraph();
    }

    protected final MObject lookupContainedMObject(Context context) {
        MObject result = AbstractSketchAction.lookupMObject(context);
        if (result != null && result.isInternalSelectable()) {
            result = this.getEditor().getContainerMObject(result);
        }
        return result;
    }

    protected static Action filterAction(Action a) {
        return a != null && a.isEnabled() ? a : null;
    }
}

