/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSelectionAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import javax.swing.Action;

public class DeleteAction
extends AbstractSelectionAction
implements PopupActionProvider {
    public DeleteAction() {
    }

    public DeleteAction(SketchPanel panel) {
        super(panel);
        this.stateChanged();
    }

    @Override
    protected Object getSelection() {
        return this.getSelectionDocument();
    }

    @Override
    protected void actionPerformed(Object selection) {
        if (selection == this.getEditor().getSelectionDocument()) {
            this.getPanel().doDeleteSelection();
        } else {
            this.delete((MSelectionDocument)selection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(MSelectionDocument selection) {
        boolean historize = this.getEditor().setHistorizeEnabled(false);
        try {
            MoleculeGraph molGraph = selection.getMainMoleculeGraph();
            MolAtom[] atoms = molGraph.getAtomArray();
            if (atoms.length == 2 && molGraph.getBondCount() == 1) {
                this.getCanvas().removeBond(molGraph.getBond(0));
            } else {
                this.getCanvas().doRemoveAtoms(atoms);
            }
            for (int i = 0; i < selection.getObjectCount(); ++i) {
                this.getCanvas().removeObject(selection.getObject(i));
            }
        }
        finally {
            this.getEditor().setHistorizeEnabled(historize);
            this.getEditor().historize();
        }
    }

    @Override
    protected boolean isEnabledFor(Object o) {
        return o instanceof MSelectionDocument && !((MSelectionDocument)o).isEmpty();
    }

    @Override
    public Action createLocalInstance(Context context) {
        MSelectionDocument document = DeleteAction.lookupSelectionDocument(context);
        return DeleteAction.filterAction(this.createLocalInstance(document));
    }
}

