/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions;

import chemaxon.marvin.sketch.swing.actions.AbstractPropertyAction;
import chemaxon.marvin.uif.action.manager.EnumeratedAction;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;

public class InverseAction
extends AbstractPropertyAction
implements EnumeratedAction<Boolean> {
    private boolean arbitary;

    public InverseAction() {
        super("selectionChanged");
    }

    public Boolean[] getValues() {
        return new Boolean[]{Boolean.TRUE, Boolean.FALSE};
    }

    @Override
    public void setValue(Boolean value) {
        this.arbitary = value;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getPanel().invertSelection(this.arbitary);
    }

    private void update() {
        this.setEnabled(this.getEditor().hasSelection() && this.getEditor().getSelectedPointCount() > 1 && this.getSelectionMolecule().getFragCount() > 0 && this.isWholeFragments());
    }

    private boolean isWholeFragments() {
        MoleculeGraph mol = this.getSelectionMolecule();
        HashSet<MolAtom> atoms = new HashSet<MolAtom>(Arrays.asList(mol.getAtomArray()));
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom atom = mol.getAtom(i);
            for (int j = 0; j < atom.getBondCount(); ++j) {
                if (atoms.contains(atom.getLigand(j))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void propertyChanged() {
        this.update();
    }
}

