/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchAction;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerStatusbarComponent;
import chemaxon.marvin.uif.action.ComponentProvider;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class StructureFixerAction
extends AbstractSketchAction
implements PopupActionProvider {
    public StructureFixerAction() {
    }

    public StructureFixerAction(SketchPanel panel) {
        super(panel);
    }

    @Override
    public Action createLocalInstance(Context context) {
        MoleculeGraph molecule = StructureFixerAction.lookupSelectionDocument(context).getMainMoleculeGraph();
        if (molecule.getAtomCount() != 1 && (molecule.getAtomCount() != 2 || molecule.getBondCount() != 1)) {
            return null;
        }
        JMenu menu = this.createMenu(context);
        return menu != null ? new Delegate(menu) : null;
    }

    private JMenu createMenu(Context context) {
        JMenu result = this.getAtomFixerMenu(context);
        if (result == null) {
            result = this.getBondFixerMenu(context);
        }
        return result;
    }

    private JMenu getAtomFixerMenu(Context context) {
        MolAtom atom = StructureFixerAction.lookupAtom(context, false);
        return atom != null ? CheckerStatusbarComponent.getFixerMenu(atom, this.getPanel()) : null;
    }

    private JMenu getBondFixerMenu(Context context) {
        MolBond bond = StructureFixerAction.lookupBond(context);
        return bond != null ? CheckerStatusbarComponent.getFixerMenu(bond, this.getPanel()) : null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private static class Delegate
    extends AbstractAction
    implements ComponentProvider.MenuItemProvider {
        private JMenu menu;

        public Delegate(JMenu menu) {
            this.menu = menu;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public JMenuItem getMenuItem() {
            return this.menu;
        }
    }
}

