/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions;

import chemaxon.marvin.common.swing.MenuBarChangeListener;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchAction;
import chemaxon.marvin.uif.action.support.AbstractExtendedAction;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JMenuBar;

public class ToggleMenuBarAction
extends AbstractSketchAction {
    private JMenuBar menubar;
    private ComponentListener visibilityHandler;

    public ToggleMenuBarAction() {
        AbstractExtendedAction.setRadio(this, false);
    }

    public ToggleMenuBarAction(SketchPanel panel) {
        super(panel);
        AbstractExtendedAction.setRadio(this, false);
        this.init();
    }

    private void init() {
        this.visibilityHandler = new VisibilityHandler();
        this.getPanel().addMenuBarChangeListener(new MenuBarChandler());
        this.handleMenuBarChange();
    }

    private void handleMenuBarChange() {
        if (this.menubar != null) {
            this.menubar.removeComponentListener(this.visibilityHandler);
        }
        this.menubar = this.getPanel().getCurrentMenuBar();
        if (this.menubar != null) {
            this.menubar.addComponentListener(this.visibilityHandler);
        }
        this.update();
    }

    private void update() {
        this.setEnabled(this.getPanel() != null && this.getPanel().getCurrentMenuBar() != null);
        AbstractExtendedAction.setSelected(this, this.menubar != null && this.menubar.isVisible());
    }

    @Override
    public void setSketchPanel(SketchPanel panel) {
        super.setSketchPanel(panel);
        this.init();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getPanel().getCurrentMenuBar().setVisible(!this.menubar.isVisible());
        this.update();
    }

    private class VisibilityHandler
    extends ComponentAdapter {
        private VisibilityHandler() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            ToggleMenuBarAction.this.update();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            ToggleMenuBarAction.this.update();
        }
    }

    private class MenuBarChandler
    extends MenuBarChangeListener {
        private MenuBarChandler() {
        }

        @Override
        public void menuBarChanged(JMenuBar mb) {
            ToggleMenuBarAction.this.handleMenuBarChange();
        }
    }
}

