/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.actions.AbstractSelectionToggleAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.marvin.uif.action.manager.EnumeratedAction;
import chemaxon.struc.MolAtom;
import javax.swing.Action;

public final class AtomRadicalAction
extends AbstractSelectionToggleAction
implements PopupActionProvider,
EnumeratedAction<Integer> {
    private int value;

    public AtomRadicalAction() {
        super(true);
    }

    public Integer[] getValues() {
        return new Integer[]{0, 1, 2, 6, 10, 3, 7, 11};
    }

    @Override
    public void setValue(Integer value) {
        this.value = value;
    }

    @Override
    protected boolean isSelected(Object o) {
        MolAtom atom = (MolAtom)o;
        return this.isEnabledFor(atom) && atom.getRadical() == this.value;
    }

    @Override
    protected Object getSelection() {
        return this.getSelectedAtom();
    }

    @Override
    protected boolean isEnabledFor(Object o) {
        MolAtom atom = (MolAtom)o;
        return atom != null && AtomRadicalAction.isNormalAtom(atom);
    }

    @Override
    protected void actionPerformed(Object selection) {
        this.getPanel().getCanvas().setRadical((MolAtom)selection, this.value);
    }

    @Override
    public Action createLocalInstance(Context context) {
        MolAtom atom = AtomRadicalAction.lookupAtom(context);
        return atom != null ? this.createLocalInstanceIfEnabled(atom) : null;
    }
}

