/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.actions.AbstractSelectionToggleAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.marvin.uif.action.manager.EnumeratedAction;
import chemaxon.struc.MolAtom;
import javax.swing.Action;

public final class AtomReactionStereoAction
extends AbstractSelectionToggleAction
implements PopupActionProvider,
EnumeratedAction<Integer> {
    private int value;

    public AtomReactionStereoAction() {
        super(true);
    }

    @Override
    public void setValue(Integer value) {
        this.value = value;
    }

    public Integer[] getValues() {
        return new Integer[]{0, 1, 2};
    }

    @Override
    protected boolean isSelected(Object o) {
        MolAtom atom = (MolAtom)o;
        return atom != null && this.isEnabledFor(o) && atom.getReactionStereo() == this.value;
    }

    @Override
    protected void actionPerformed(Object selection) {
        MolAtom atom = (MolAtom)selection;
        this.getPanel().getCanvas().setReactionStereo(atom, this.value);
    }

    @Override
    protected Object getSelection() {
        return this.getSelectedAtom();
    }

    @Override
    protected boolean isEnabledFor(Object o) {
        MolAtom atom = (MolAtom)o;
        return atom != null && AtomReactionStereoAction.isNormalAtom(atom);
    }

    @Override
    public Action createLocalInstance(Context context) {
        return AtomReactionStereoAction.lookupAtom(context) != null ? this.createLocalInstanceIfEnabled(AtomReactionStereoAction.lookupAtom(context)) : null;
    }
}

