/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchAction;
import chemaxon.marvin.sketch.swing.actions.atom.MenuUtil;
import chemaxon.marvin.uif.action.support.AbstractStateAction;
import chemaxon.marvin.uif.util.Utils;
import chemaxon.struc.MolAtom;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;

class EnhancedStereoAction
extends AbstractStateAction {
    private static final ResourceBundle bundle = ResourceBundle.getBundle(EnhancedStereoAction.class.getName());
    private SketchPanel panel;
    private MolAtom atom;
    private Integer stereo;
    private int flag;

    public EnhancedStereoAction(SketchPanel panel, int flag, int index) {
        this.panel = panel;
        this.flag = flag;
        this.init(flag, index);
        this.update();
    }

    private void init(int flag, int index) {
        this.flag = flag;
        if (flag == 0) {
            this.putValue("Name", Utils.getString(bundle, "none.name", "Off"));
            this.stereo = new Integer(flag);
        } else if (flag == 2 && index != -1) {
            this.putValue("Name", Utils.getString(bundle, "or.name", "OR") + index);
            this.stereo = this.convert(index);
        } else if (flag == 2 && index == -1) {
            this.putValue("Name", Utils.getString(bundle, "custom.or.name", "OR..."));
            this.stereo = null;
        } else if (flag == 1) {
            this.putValue("Name", Utils.getString(bundle, "absolute.name", "Absolute"));
            this.stereo = new Integer(flag);
        } else if (flag == 3 && index != -1) {
            this.putValue("Name", Utils.getString(bundle, "and.name", "AND") + index);
            this.stereo = this.convert(index);
        } else if (flag == 3 && index == -1) {
            this.putValue("Name", Utils.getString(bundle, "custom.and.name", "AND..."));
            this.stereo = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Integer value = this.stereo;
        if (value == null) {
            value = this.convert(this.showCustomDialog());
        }
        if (value != null) {
            this.panel.getCanvas().setEnhancedStereo(this.atom, value);
        }
    }

    void setAtom(MolAtom atom) {
        this.atom = atom;
        this.update();
    }

    private Integer showCustomDialog() {
        String title;
        String prefix;
        String key;
        if (this.flag == 2) {
            key = "custom.or.message";
            prefix = "OR";
            title = "or.title";
        } else {
            key = "custom.and.message";
            prefix = "AND";
            title = "and.title";
        }
        return MenuUtil.showIntegerInputDialog(this.panel, bundle.getString(key), bundle.getString(title), prefix);
    }

    private Integer convert(int input) {
        return this.convert(new Integer(input));
    }

    private Integer convert(Integer input) {
        if (input == null) {
            return null;
        }
        return new Integer(this.flag | input << 16);
    }

    private Integer getStereo() {
        int result = this.atom.getStereoGroupType();
        if (result == 2 || result == 3) {
            int n = this.atom.getStereoGroupNumber();
            if (n <= Short.MAX_VALUE) {
                result |= n << 16;
            } else {
                return null;
            }
        }
        return new Integer(result);
    }

    private void update() {
        this.setEnabled(AbstractSketchAction.isNormalAtom(this.atom));
        this.setSelected(this.isEnabled() && this.stereo != null && this.stereo.equals(this.getStereo()));
    }
}

