/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.atom.MenuUtil;
import chemaxon.marvin.uif.action.support.AbstractStateAction;
import chemaxon.struc.MolAtom;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;

class MapAction
extends AbstractStateAction {
    static final int CUSTOM = Integer.MIN_VALUE;
    private static final ResourceBundle bundle = ResourceBundle.getBundle(MapAction.class.getName());
    private SketchPanel panel;
    private MolAtom atom;
    private int value;

    public MapAction(SketchPanel panel, int value) {
        this.panel = panel;
        this.value = value;
        this.setRadio(true);
        this.init();
        this.update();
    }

    private void init() {
        if (this.value == Integer.MIN_VALUE) {
            this.putValue("Name", "M...");
        } else if (this.value == 0) {
            this.putValue("Name", bundle.getString("noneLabel"));
        } else {
            this.putValue("Name", "M" + this.value);
        }
    }

    private void update() {
        this.setEnabled(this.atom != null && (this.atom.isMappable() || this.atom.getAtomMap() > 0));
        this.setSelected(this.isEnabled() && this.atom.getAtomMap() == this.value);
    }

    void setAtom(MolAtom atom) {
        this.atom = atom;
        this.update();
    }

    @Override
    public void actionPerformed(ActionEvent ignored) {
        int number = this.value;
        if (this.value == Integer.MIN_VALUE) {
            Integer result = MenuUtil.showIntegerInputDialog(this.panel, bundle.getString("custom.message"), bundle.getString("title"), "M");
            if (result == null) {
                return;
            }
            number = result;
        }
        this.panel.getCanvas().setAtomMap(this.atom, number);
    }
}

