/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.uif.action.support.ToggleButtonBinding;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

class MenuUtil {
    private static ResourceBundle bundle = ResourceBundle.getBundle(MenuUtil.class.getName());
    private static final String MAX_ARROW_ICON_WIDTH = "maxArrowIconWidth";
    private static final String MAX_CHECK_ICON_WIDTH = "maxCheckIconWidth";
    private static final String MAX_ICON_WIDTH = "maxIconWidth";
    private static final String MAX_TEXT_WIDTH = "maxTextWidth";
    private static final String MAX_ACC_WIDTH = "maxAccWidth";
    private static final StringBuffer MAX_ICON_OFFSET = new StringBuffer("maxIconOffset");
    private static final StringBuffer MAX_TEXT_OFFSET = new StringBuffer("maxTextOffset");

    private MenuUtil() {
    }

    public static Integer showIntegerInputDialog(Component parent, String message, String title) {
        return MenuUtil.showIntegerInputDialog(parent, message, title, null);
    }

    static Integer showIntegerInputDialog(Component parent, String message, String title, String prefix) {
        String result = JOptionPane.showInputDialog(parent, message, title, 3);
        if (result == null) {
            return null;
        }
        result = result.trim();
        if (prefix != null && result.toUpperCase().startsWith(prefix.toUpperCase())) {
            result = result.substring(prefix.length()).trim();
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public static void fill(JMenu menu, List actions, int maxRow) {
        JPopupMenu popup = menu.getPopupMenu();
        MenuUtil.removeAll(popup);
        MenuUtil.removeMenuProperties(popup);
        if (actions.size() == 0) {
            MenuUtil.fillEmpty(menu);
            return;
        }
        if (maxRow != -1) {
            MenuUtil.fillSpecial(actions, maxRow, popup);
        } else {
            MenuUtil.fill(actions, popup);
        }
        popup.revalidate();
        popup.repaint();
    }

    private static void removeAll(JPopupMenu popup) {
        for (int i = 0; i < popup.getComponentCount(); ++i) {
            Component component = popup.getComponent(i);
            if (!(component instanceof JMenuItem)) continue;
            ((JMenuItem)component).setAction(null);
        }
        popup.removeAll();
    }

    private static void fillSpecial(List actions, int maxRow, JPopupMenu popup) {
        GridBagLayout layout = new GridBagLayout();
        popup.setLayout(layout);
        int cols = (actions.size() + maxRow - 1) / maxRow;
        int rows = (actions.size() + cols - 1) / cols;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        for (int i = 0; i < actions.size(); ++i) {
            Action action = (Action)actions.get(i);
            if (action != null) {
                JMenuItem item = MenuUtil.createItem(action);
                layout.addLayoutComponent(item, gbc);
                popup.add(item);
            } else {
                JMenuItem filler = new JMenuItem();
                filler.setVisible(false);
                popup.add(filler);
            }
            if (gbc.gridy < rows - 1) {
                ++gbc.gridy;
                continue;
            }
            gbc.gridy = 0;
            ++gbc.gridx;
        }
    }

    private static void fill(List actions, JPopupMenu popup) {
        for (Action action : actions) {
            if (action == null) continue;
            popup.add(MenuUtil.createItem(action));
        }
    }

    private static JMenuItem createItem(Action action) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
        ToggleButtonBinding.bind(item, action);
        return item;
    }

    private static void fillEmpty(JMenu menu) {
        JMenuItem empty = new JMenuItem(bundle.getString("emptyLabel"));
        empty.setEnabled(false);
        menu.getPopupMenu().add(empty);
    }

    private static void removeMenuProperties(JPopupMenu target) {
        target.putClientProperty(MAX_ARROW_ICON_WIDTH, null);
        target.putClientProperty(MAX_CHECK_ICON_WIDTH, null);
        target.putClientProperty(MAX_ICON_WIDTH, null);
        target.putClientProperty(MAX_TEXT_WIDTH, null);
        target.putClientProperty(MAX_ACC_WIDTH, null);
        target.putClientProperty(MAX_ICON_OFFSET, null);
        target.putClientProperty(MAX_TEXT_OFFSET, null);
    }
}

