/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.uif.action.support.AbstractStateAction;
import chemaxon.struc.MolAtom;
import java.awt.event.ActionEvent;

class RgroupAttachmentAction
extends AbstractStateAction {
    private SketchPanel panel;
    private int order;
    private MolAtom atom;

    public RgroupAttachmentAction(SketchPanel panel, MolAtom atom, String name, int order) {
        super(name);
        this.panel = panel;
        this.order = order;
        this.setRadio(true);
        this.atom = atom;
        this.update();
    }

    private void update() {
        this.setEnabled(this.atom != null && this.atom.getRgroupAttachmentPointOrder() > 0);
        this.setSelected(this.isEnabled() && this.atom.getRgroupAttachmentPointOrder() == this.order);
    }

    void setAtom(MolAtom atom) {
        this.atom = atom;
        this.update();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.panel.getCanvas().setRgroupAttachmentPointOrder(this.atom, this.order);
    }
}

