/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.actions.AbstractSelectionToggleAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.marvin.uif.module.ActionFactory;
import chemaxon.struc.MolAtom;
import java.util.ArrayList;
import javax.swing.Action;

public class SubstitutionCountAction
extends AbstractSelectionToggleAction
implements PopupActionProvider,
ActionFactory {
    private static final String ID_PREFIX = "atomSubst.";
    private int value;

    public SubstitutionCountAction(int value) {
        super(true);
        this.value = value;
    }

    public SubstitutionCountAction() {
        super(true);
    }

    @Override
    protected boolean isSelected(Object atom) {
        return ((MolAtom)atom).getQPropAsInt("s") == this.value;
    }

    @Override
    protected void actionPerformed(Object selection) {
        this.getEditor().abEdit(39, this.getEditor().indexOf((MolAtom)selection), this.value);
    }

    @Override
    protected Object getSelection() {
        return this.getSelectedAtom();
    }

    @Override
    protected boolean isEnabledFor(Object o) {
        return o instanceof MolAtom && SubstitutionCountAction.isNormalAtom((MolAtom)o);
    }

    @Override
    public Action createLocalInstance(Context context) {
        MolAtom atom = SubstitutionCountAction.lookupAtom(context);
        return atom != null ? this.createLocalInstanceIfEnabled(atom) : null;
    }

    @Override
    public Action[] createActions() {
        ArrayList<Action> result = new ArrayList<Action>();
        result.add(SubstitutionCountAction.createAction(-1, "Off", "Substitution count off", "Removes the substitution count atomic property"));
        result.add(SubstitutionCountAction.createAction(-2, "s*", "Substitution count as drawn", "Set the number of non-hydrogen substituents to be as drawn"));
        for (int i = 0; i < 7; ++i) {
            result.add(SubstitutionCountAction.createAction(i, "s" + i, this.getDescription(i), "Set the number of non-hydrogen substituents to " + i));
        }
        return result.toArray(new Action[result.size()]);
    }

    private String getDescription(int i) {
        String name = i + " Substituent";
        if (i > 1) {
            name = name + "s";
        }
        return name;
    }

    private static Action createAction(int value, String name, String desc, String longDesc) {
        SubstitutionCountAction result = new SubstitutionCountAction(value);
        result.putValue("ActionCommandKey", ID_PREFIX + name.toLowerCase());
        result.putValue("Name", name);
        result.putValue("ShortDescription", desc);
        result.putValue("LongDescription", longDesc);
        return result;
    }
}

