/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.bond;

import chemaxon.marvin.sketch.BondSM;
import chemaxon.marvin.sketch.swing.actions.AbstractSelectionToggleAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import javax.swing.Action;

public class BoldBondAction
extends AbstractSelectionToggleAction
implements PopupActionProvider {
    public BoldBondAction() {
        super(false);
    }

    @Override
    public Action createLocalInstance(Context context) {
        MSelectionDocument selection = context.lookup(MSelectionDocument.class);
        if (selection == null || !this.isAllowed()) {
            return null;
        }
        return this.createLocalInstance(selection.getMainMoleculeGraph());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBondFlagForAll(MoleculeGraph molecule) {
        boolean historizeEnabled = this.getEditor().setHistorizeEnabled(false);
        try {
            boolean toBold = !this.isSelected(molecule);
            for (int i = 0; i < molecule.getBondCount(); ++i) {
                this.setBondFlag(molecule.getBond(i), toBold);
            }
        }
        finally {
            this.getEditor().setHistorizeEnabled(historizeEnabled);
            this.getEditor().historize();
        }
    }

    protected void setBondFlag(MolBond bond, boolean toBold) {
        int pflags = bond.getFlags();
        int pt = pflags & 0xF;
        int pstereo = pflags & 0x230;
        int ptopo = pflags & 0xC00;
        if (toBold && !bond.isBold()) {
            if (pflags == 1 || pflags == 2 || pflags == 4) {
                bond.setFlags(0x40000000 | pflags);
            } else {
                this.getEditor().ungroupSgroupOf(bond);
                if (pt == 4 && pstereo == 16 && ptopo == 0) {
                    bond.setFlags(0x40000004);
                } else {
                    bond.setFlags(0x40000001);
                }
            }
            MolAtom a1 = bond.getAtom1();
            MolAtom a2 = bond.getAtom2();
            a1.valenceCheck();
            a2.valenceCheck();
        } else if (!toBold) {
            bond.setFlags(pt);
        }
    }

    @Override
    protected boolean isSelected(Object o) {
        if (o == null) {
            return false;
        }
        MoleculeGraph mg = (MoleculeGraph)o;
        int n = mg.getBondCount();
        for (int i = 0; i < n; ++i) {
            MolBond bond = mg.getBond(i);
            if (bond.isBold()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Object getSelection() {
        return this.getSelectionMolecule();
    }

    @Override
    protected boolean isEnabledFor(Object o) {
        return o != null && this.isAllowed() && ((MoleculeGraph)o).getBondCount() > 0;
    }

    private boolean isAllowed() {
        Molecule mol = BondSM.createBondMol(0x40000001);
        return this.getEditor() != null && this.getEditor().isAllowed(mol);
    }

    @Override
    protected void actionPerformed(Object value) {
        this.setBondFlagForAll((MoleculeGraph)value);
        this.getPanel().updateControls();
    }
}

