/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.bond;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSelectionToggleAction;
import chemaxon.marvin.sketch.swing.actions.bond.BitUtil;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import javax.swing.Action;

public class BondStereoSearchAction
extends AbstractSelectionToggleAction
implements PopupActionProvider {
    public BondStereoSearchAction(SketchPanel panel) {
        super(panel, false);
        this.stateChanged();
    }

    public BondStereoSearchAction() {
        super(false);
    }

    @Override
    public Action createLocalInstance(Context context) {
        MSelectionDocument document = context.lookup(MSelectionDocument.class);
        if (document == null) {
            return null;
        }
        return this.createLocalInstance(document.getMainMoleculeGraph());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object value) {
        boolean historizationEnabled = this.getEditor().setHistorizeEnabled(false);
        try {
            MoleculeGraph molecule = (MoleculeGraph)value;
            boolean selected = this.isSelected(value);
            for (int i = 0; i < molecule.getBondCount(); ++i) {
                MolBond bond = molecule.getBond(i);
                if (!this.isEnabledFor(bond)) continue;
                int flags = BitUtil.set(bond.getFlags(), 512, !selected);
                this.getPanel().getCanvas().setBondFlags(bond, flags);
            }
        }
        finally {
            this.getEditor().setHistorizeEnabled(historizationEnabled);
            this.getEditor().historize();
        }
    }

    @Override
    protected boolean isSelected(Object value) {
        if (!this.isEnabledFor(value)) {
            return false;
        }
        MoleculeGraph molecule = (MoleculeGraph)value;
        if (molecule.getBondCount() == 0) {
            return false;
        }
        for (int i = 0; i < molecule.getBondCount(); ++i) {
            if (!this.isEnabledFor(molecule.getBond(i)) || BitUtil.isSet(molecule.getBond(i).getFlags(), 512)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Object getSelection() {
        return this.getSelectionMolecule();
    }

    @Override
    protected boolean isEnabledFor(Object o) {
        if (!(o instanceof MoleculeGraph)) {
            return false;
        }
        MoleculeGraph molecule = (MoleculeGraph)o;
        for (int i = 0; i < molecule.getBondCount(); ++i) {
            MolBond bond = molecule.getBond(i);
            if (!this.isEnabledFor(bond)) continue;
            return true;
        }
        return false;
    }

    private boolean isEnabledFor(MolBond bond) {
        return bond.getType() != 1 && bond.getType() != 9 && bond.getType() != 6;
    }
}

