/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.bond;

import chemaxon.marvin.sketch.BondSM;
import chemaxon.marvin.sketch.swing.actions.AbstractSelectionToggleAction;
import chemaxon.marvin.sketch.swing.actions.bond.BitUtil;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.DynamicMenuProvider;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.marvin.uif.action.manager.EnumeratedAction;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import javax.swing.Action;

public final class BondTopologyAction
extends AbstractSelectionToggleAction
implements PopupActionProvider,
DynamicMenuProvider,
EnumeratedAction<Integer> {
    private static final Action[] NULL_ACTION = new Action[0];
    private Molecule molecule;
    private int type;

    public BondTopologyAction() {
        super(true);
    }

    @Override
    public void setValue(Integer value) {
        this.type = value;
        this.molecule = BondSM.createBondMol(this.type | 1);
    }

    public Integer[] getValues() {
        return new Integer[]{1024, 2048, 0};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object value) {
        MoleculeGraph molecule = (MoleculeGraph)value;
        boolean historizeEnabled = this.getEditor().setHistorizeEnabled(false);
        try {
            for (int i = 0; i < molecule.getBondCount(); ++i) {
                MolBond bond = molecule.getBond(i);
                int flags = BitUtil.setInt(bond.getFlags(), 3072, this.type);
                this.getPanel().getCanvas().setBondFlags(bond, flags);
            }
        }
        finally {
            this.getEditor().setHistorizeEnabled(historizeEnabled);
            this.getEditor().historize();
        }
    }

    @Override
    protected boolean isSelected(Object value) {
        if (!this.isEnabledFor(value)) {
            return false;
        }
        MoleculeGraph molecule = (MoleculeGraph)value;
        if (molecule.getBondCount() == 0) {
            return false;
        }
        for (int i = 0; i < molecule.getBondCount(); ++i) {
            if (BitUtil.getInt(molecule.getBond(i).getFlags(), 3072) == this.type) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Object getSelection() {
        return this.getSelectionMolecule();
    }

    @Override
    protected boolean isEnabledFor(Object o) {
        return o instanceof MoleculeGraph && ((MoleculeGraph)o).getBondCount() > 0 && this.isAllowed();
    }

    private boolean isAllowed() {
        return this.getEditor().isAllowed(this.molecule);
    }

    @Override
    public Action[] getMenuItems() {
        if (this.isAllowed()) {
            return new Action[]{this};
        }
        return NULL_ACTION;
    }

    @Override
    public Action createLocalInstance(Context context) {
        if (!this.isAllowed()) {
            return null;
        }
        MSelectionDocument document = context.lookup(MSelectionDocument.class);
        if (document == null) {
            return null;
        }
        return this.createLocalInstance(document.getMainMoleculeGraph());
    }
}

