/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.bond;

import chemaxon.marvin.sketch.BondSM;
import chemaxon.marvin.sketch.swing.actions.AbstractSelectionToggleAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.DynamicMenuProvider;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.marvin.uif.action.manager.EnumeratedAction;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import java.util.Arrays;
import javax.swing.Action;

public class BondTypeAction
extends AbstractSelectionToggleAction
implements PopupActionProvider,
DynamicMenuProvider,
EnumeratedAction<Integer> {
    private static final Integer[] VALUES = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 9, 17, 33, 49, 194, 450};
    private Molecule mol;
    private int type;

    public BondTypeAction() {
        super(true);
    }

    public Integer[] getValues() {
        return (Integer[])VALUES.clone();
    }

    @Override
    public void setValue(Integer value) {
        this.type = value;
        this.mol = BondSM.createBondMol(this.type);
    }

    @Override
    public Action createLocalInstance(Context context) {
        MSelectionDocument selection = context.lookup(MSelectionDocument.class);
        if (selection == null || !this.isAllowed()) {
            return null;
        }
        return this.createLocalInstance(selection.getMainMoleculeGraph());
    }

    @Override
    public Action[] getMenuItems() {
        if (this.isAllowed()) {
            return new Action[]{this};
        }
        return new Action[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBondFlagForAll(MoleculeGraph molecule, int flag, boolean keepStereo2Care) {
        boolean historizeEnabled = this.getEditor().setHistorizeEnabled(false);
        try {
            for (int i = 0; i < molecule.getBondCount(); ++i) {
                this.setBondFlag(molecule.getBond(i), flag, keepStereo2Care);
            }
        }
        finally {
            this.getEditor().setHistorizeEnabled(historizeEnabled);
            this.getEditor().historize();
        }
    }

    protected void setBondFlag(MolBond bond, int flag, boolean keepStereo2Care) {
        int newFlags = bond.getFlags() & 0xBFFFFC00;
        newFlags |= flag;
        if (keepStereo2Care) {
            newFlags |= bond.getFlags() & 0x200;
        }
        this.getPanel().getCanvas().setBondFlags(bond, newFlags);
    }

    protected boolean isSelected(MolBond bond, int stereo1, int stereo2) {
        int pos = Arrays.asList(VALUES).indexOf(this.type);
        switch (pos) {
            case 0: {
                return stereo1 == 0 && stereo2 == 0 && bond.getType() == 0;
            }
            case 1: {
                return stereo1 == 0 && stereo2 == 0 && bond.getType() == 1;
            }
            case 2: {
                return stereo1 == 0 && stereo2 == 0 && bond.getType() == 2;
            }
            case 3: {
                return stereo1 == 0 && stereo2 == 0 && bond.getType() == 3;
            }
            case 4: {
                return stereo1 == 0 && stereo2 == 0 && bond.getType() == 4;
            }
            case 5: {
                return stereo1 == 0 && stereo2 == 0 && bond.getType() == 5;
            }
            case 6: {
                return stereo1 == 0 && stereo2 == 0 && bond.getType() == 6;
            }
            case 7: {
                return stereo1 == 0 && stereo2 == 0 && bond.getType() == 7;
            }
            case 8: {
                return stereo1 == 0 && stereo2 == 0 && bond.getType() == 9;
            }
            case 9: {
                return stereo1 == 16 && bond.getType() == 1;
            }
            case 10: {
                return stereo1 == 32 && bond.getType() == 1;
            }
            case 11: {
                return stereo1 == 48 && bond.getType() == 1;
            }
            case 12: {
                return stereo2 == 192 && bond.getType() == 2;
            }
            case 13: {
                return stereo2 != 192 && (stereo2 & 0x100) != 0 && bond.getType() == 2;
            }
        }
        return false;
    }

    @Override
    protected boolean isSelected(Object value) {
        if (value == null || !this.isEnabledFor(value)) {
            return false;
        }
        MoleculeGraph molecule = (MoleculeGraph)value;
        if (molecule.getBondCount() == 0) {
            return false;
        }
        for (int i = 0; i < molecule.getBondCount(); ++i) {
            MolBond bond = molecule.getBond(i);
            if (this.isSelected(bond, bond.getFlags() & 0x30, bond.getFlags() & 0x1C0)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Object getSelection() {
        return this.getSelectionMolecule();
    }

    @Override
    protected boolean isEnabledFor(Object o) {
        return this.getEditor() != null && this.isAllowed() && o != null && ((MoleculeGraph)o).getBondCount() > 0;
    }

    private boolean isAllowed() {
        return this.getEditor() != null && this.getEditor().isAllowed(this.mol);
    }

    @Override
    protected void actionPerformed(Object value) {
        this.setBondFlagForAll((MoleculeGraph)value, this.type, this.type != 1 && this.type != 6);
    }
}

