/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.bond;

import chemaxon.marvin.sketch.BondSM;
import chemaxon.marvin.sketch.swing.actions.AbstractSelectionToggleAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import javax.swing.Action;

public class HashedBondAction
extends AbstractSelectionToggleAction
implements PopupActionProvider {
    private static final long serialVersionUID = -8457165788232947537L;

    public HashedBondAction() {
        super(false);
    }

    @Override
    public Action createLocalInstance(Context context) {
        MSelectionDocument selection = context.lookup(MSelectionDocument.class);
        if (selection == null || !this.isAllowed()) {
            return null;
        }
        return this.createLocalInstance(selection.getMainMoleculeGraph());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBondFlagForAll(MoleculeGraph molecule) {
        boolean historizeEnabled = this.getEditor().setHistorizeEnabled(false);
        try {
            boolean toHashed = !this.isSelected(molecule);
            for (int i = 0; i < molecule.getBondCount(); ++i) {
                this.setBondFlag(molecule.getBond(i), toHashed);
            }
        }
        finally {
            this.getEditor().setHistorizeEnabled(historizeEnabled);
            this.getEditor().historize();
        }
    }

    protected void setBondFlag(MolBond bond, boolean toHashed) {
        int pflags = bond.getFlags();
        int pt = pflags & 0xF;
        if (toHashed && !bond.isHashed()) {
            bond.setFlags(-2147483647);
            MolAtom a1 = bond.getAtom1();
            MolAtom a2 = bond.getAtom2();
            a1.valenceCheck();
            a2.valenceCheck();
        } else if (!toHashed) {
            bond.setFlags(pt);
        }
    }

    private boolean isAllowed() {
        Molecule mol = BondSM.createBondMol(-2147483647);
        return this.getEditor() != null && this.getEditor().isAllowed(mol);
    }

    @Override
    protected boolean isSelected(Object value) {
        if (value == null) {
            return false;
        }
        MoleculeGraph mg = (MoleculeGraph)value;
        int n = mg.getBondCount();
        for (int i = 0; i < n; ++i) {
            MolBond bond = mg.getBond(i);
            if (bond.isHashed()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Object getSelection() {
        return this.getSelectionMolecule();
    }

    @Override
    protected void actionPerformed(Object selection) {
        this.setBondFlagForAll((MoleculeGraph)selection);
        this.getPanel().updateControls();
    }

    @Override
    protected boolean isEnabledFor(Object o) {
        return o != null && this.isAllowed() && ((MoleculeGraph)o).getBondCount() > 0;
    }
}

