/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.group;

import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.SgroupPO;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSelectionAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;

public class UngroupSGroupAction
extends AbstractSelectionAction
implements PopupActionProvider {
    private static final long serialVersionUID = 1L;

    public UngroupSGroupAction() {
    }

    public UngroupSGroupAction(SketchPanel panel) {
        super(panel);
        this.stateChanged();
    }

    @Override
    protected void actionPerformed(Object selection) {
        if (selection instanceof Sgroup) {
            this.actionPerformed((Sgroup)selection);
        } else {
            this.actionPerformed((MSelectionDocument)selection);
        }
    }

    private void actionPerformed(Sgroup sgroup) {
        this.getPanel().doUngroupSgroup(new SgroupPO(sgroup));
    }

    private void actionPerformed(MSelectionDocument document) {
        SgroupPO group = this.getEditor().getSgroupPO(document.getMainMoleculeGraph());
        if (group != null) {
            this.getPanel().doUngroupSgroup(group);
        } else {
            if (!document.isEmpty()) {
                this.selectDocument(document.getMainMoleculeGraph());
            }
            this.getPanel().doUngroupSgroup(null);
        }
    }

    @Override
    protected Object getSelection() {
        return this.getSelectionDocument();
    }

    @Override
    protected boolean isEnabledFor(Object o) {
        if (o instanceof Sgroup) {
            return true;
        }
        MSelectionDocument document = (MSelectionDocument)o;
        return this.isEnabled(document);
    }

    private boolean isEnabled(MSelectionDocument document) {
        return document != null && (document.isEmpty() && this.getEditor().hasUngroupableGroup() || this.getEditor().hasUngroupableGroup(UngroupSGroupAction.collectAtoms(document.getMainMoleculeGraph())));
    }

    @Override
    public Action createLocalInstance(Context context) {
        return this.createLocalInstanceIfEnabled(UngroupSGroupAction.guessSelection(context));
    }

    private static Object guessSelection(Context context) {
        MSelectionDocument selection = UngroupSGroupAction.lookupSelectionDocument(context);
        if (selection.isEmpty() || !selection.getMainMoleculeGraph().isEmpty()) {
            return selection;
        }
        Sgroup sgroup = UngroupSGroupAction.lookupSGroup(context);
        return sgroup != null ? sgroup : selection;
    }

    private void selectDocument(MoleculeGraph mol) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolEditor.selectAtom(mol.getAtom(i), this.getSelectionMolecule());
        }
    }

    private static Set<MolAtom> collectAtoms(MoleculeGraph selection) {
        HashSet<MolAtom> result = new HashSet<MolAtom>();
        for (int i = 0; i < selection.getAtomCount(); ++i) {
            result.add(selection.getAtom(i));
        }
        return result;
    }
}

