/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.property;

import chemaxon.marvin.paint.DispOptConsts;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractPropertyAction;
import chemaxon.marvin.uif.action.support.AbstractExtendedAction;
import java.awt.event.ActionEvent;

public abstract class AbstractColorSchemeAction
extends AbstractPropertyAction {
    private static final String COLOR_SCHEME = "colorScheme";
    private String scheme;
    private int schemeID;

    public AbstractColorSchemeAction(SketchPanel panel, String scheme) {
        super(panel, COLOR_SCHEME);
        this.init(scheme);
        this.propertyChanged();
    }

    public AbstractColorSchemeAction(String scheme) {
        super(COLOR_SCHEME);
        this.init(scheme);
    }

    private void init(String scheme) {
        this.scheme = scheme;
        this.schemeID = AbstractColorSchemeAction.getSchemeID(scheme);
        AbstractExtendedAction.setRadio(this, true);
    }

    private static int getSchemeID(String scheme) {
        for (int i = 0; i < DispOptConsts.COLOR_SCHEMES.length; ++i) {
            if (!DispOptConsts.COLOR_SCHEMES[i].equals(scheme)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unknown color scheme: " + scheme);
    }

    @Override
    protected void propertyChanged() {
        AbstractExtendedAction.setSelected(this, this.isSchemeSelected());
    }

    private boolean isSchemeSelected() {
        return this.scheme.equals(this.getPanel().getColorScheme());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isSchemeSelected()) {
            this.getPanel().doSetColorScheme(this.schemeID);
        }
    }
}

