/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.structure;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractPropertyAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import java.util.ResourceBundle;
import javax.swing.Action;

public abstract class AbstractReactionFragsAction
extends AbstractPropertyAction
implements PopupActionProvider {
    private static final String AGENT = "agent";
    private static final String REACTANT = "reactant";
    private static final String PRODUCT = "product";
    private static final String SELECTION_CHANGED = "selectionChanged";
    private static final String TARGET = "target";
    private int type;
    private ResourceBundle bundle;

    public AbstractReactionFragsAction(SketchPanel panel) {
        super(panel, SELECTION_CHANGED);
        this.init();
        this.propertyChanged();
    }

    public AbstractReactionFragsAction() {
        super(SELECTION_CHANGED);
        this.init();
    }

    private void init() {
        this.bundle = ResourceBundle.getBundle(AbstractReactionFragsAction.class.getName());
        this.setType(0);
        this.putValue(TARGET, this.getLabel(this.getType()));
    }

    @Override
    protected void propertyChanged() {
        int newType = this.findType();
        if (newType != -1) {
            this.setType(newType);
            this.setEnabled(this.isValidSelection());
            this.putValue(TARGET, this.getLabel(this.getType()));
        } else {
            this.setEnabled(false);
        }
    }

    protected abstract boolean isValidSelection();

    @Override
    public Action createLocalInstance(Context context) {
        return this.isEnabled() ? this : null;
    }

    protected String getLabel(int type) {
        if (type == 1) {
            return this.bundle.getString(PRODUCT);
        }
        if (type == 0) {
            return this.bundle.getString(REACTANT);
        }
        return this.bundle.getString(AGENT);
    }

    private int findType() {
        RxnMolecule rxmol = null;
        rxmol = RxnMolecule.getReaction(this.getEditor().getMol());
        SelectionMolecule sel = this.getEditor().getSelectionMolecule();
        if (rxmol == null || sel.isEmpty()) {
            return -1;
        }
        int r = 0;
        int p = 0;
        int a = 0;
        block5: for (int i = sel.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = sel.getAtom(i);
            if (!rxmol.contains(atom)) {
                return -1;
            }
            for (int j = atom.getBondCount() - 1; j >= 0; --j) {
                MolBond edge = atom.getBond(j);
                if (sel.contains(edge)) continue;
                return -1;
            }
            int t = rxmol.determineType(atom.getX(), atom.getY(), atom.getZ());
            switch (t) {
                case 0: {
                    ++r;
                    continue block5;
                }
                case 1: {
                    ++p;
                    continue block5;
                }
                case 2: {
                    ++a;
                }
            }
        }
        if (r != sel.getAtomCount() && p != sel.getAtomCount() && a != sel.getAtomCount()) {
            return -1;
        }
        int m = Math.max(Math.max(r, p), a);
        if (m == r) {
            return 0;
        }
        if (m == p) {
            return 1;
        }
        return 2;
    }

    protected void setType(int type) {
        this.type = type;
    }

    protected int getType() {
        return this.type;
    }
}

