/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.structure;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSelectionAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.DataSgroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;

public class DeleteDataAction
extends AbstractSelectionAction
implements PopupActionProvider {
    public DeleteDataAction() {
    }

    public DeleteDataAction(SketchPanel panel) {
        super(panel);
        this.stateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object selection) {
        DataSgroup[] sgroups = this.getSelectedSgroups(selection);
        if (sgroups.length == 0) {
            return;
        }
        boolean historize = this.getEditor().setHistorizeEnabled(false);
        try {
            for (int i = 0; i < sgroups.length - 1; ++i) {
                this.getEditor().edit(19, this.getEditor().getMol().indexOf(sgroups[i]));
            }
            this.getPanel().doDeleteData(sgroups[sgroups.length - 1]);
        }
        finally {
            this.getEditor().setHistorizeEnabled(historize);
            this.getEditor().historize();
        }
    }

    @Override
    protected Object getSelection() {
        MSelectionDocument selection = this.getSelectionDocument();
        if (!selection.isEmpty()) {
            return selection.getMainMoleculeGraph();
        }
        return this.getEditor().getMol();
    }

    @Override
    protected boolean isEnabledFor(Object o) {
        return this.hasDataSgroup(o);
    }

    private boolean hasDataSgroup(Object o) {
        int i;
        if (o == null) {
            return false;
        }
        if (o instanceof DataSgroup) {
            return true;
        }
        MoleculeGraph graph = (MoleculeGraph)o;
        if (graph == this.getEditor().getMol()) {
            return this.getSgroups().length > 0;
        }
        DataSgroup[] sgroups = this.getSgroups();
        if (sgroups.length == 0) {
            return false;
        }
        if (sgroups.length != 0 && graph.getAtomCount() == 0) {
            return true;
        }
        HashSet<MolAtom> atoms = new HashSet<MolAtom>();
        for (i = 0; i < sgroups.length; ++i) {
            atoms.addAll(Arrays.asList(sgroups[i].getAtomArray()));
        }
        for (i = 0; i < graph.getAtomCount(); ++i) {
            if (!atoms.contains(graph.getAtom(i))) continue;
            return true;
        }
        return false;
    }

    private DataSgroup[] getSelectedSgroups(Object object) {
        if (object instanceof DataSgroup) {
            return new DataSgroup[]{(DataSgroup)object};
        }
        MoleculeGraph selection = (MoleculeGraph)object;
        DataSgroup[] sgroups = this.getSgroups();
        ArrayList<DataSgroup> result = new ArrayList<DataSgroup>();
        HashSet<MolAtom> atoms = new HashSet<MolAtom>(Arrays.asList(selection.getAtomArray()));
        for (int i = 0; i < sgroups.length; ++i) {
            if (!this.isSelected(atoms, sgroups[i])) continue;
            result.add(sgroups[i]);
        }
        return result.toArray(new DataSgroup[result.size()]);
    }

    private boolean isSelected(Set atoms, DataSgroup dataSgroup) {
        for (int j = 0; j < dataSgroup.getAtomCount(); ++j) {
            if (!atoms.contains(dataSgroup.getAtom(j))) continue;
            return true;
        }
        return false;
    }

    private DataSgroup[] getSgroups() {
        Molecule molecule = this.getEditor().getMol();
        ArrayList<Sgroup> result = new ArrayList<Sgroup>();
        for (int i = 0; i < molecule.getSgroupCount(); ++i) {
            if (!(molecule.getSgroup(i) instanceof DataSgroup)) continue;
            result.add(molecule.getSgroup(i));
        }
        return result.toArray(new DataSgroup[result.size()]);
    }

    @Override
    public Action createLocalInstance(Context context) {
        DataSgroup group = DeleteDataAction.lookupDataSgroup(context);
        if (group != null) {
            if (group.getAtomCount() == 0) {
                return this.createLocalInstance(group);
            }
            return this.createLocalInstance(DeleteDataAction.lookupSelectionDocument(context).getMainMoleculeGraph());
        }
        return null;
    }
}

