/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.structure;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.structure.AbstractReactionFragsAction;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import java.awt.event.ActionEvent;

public class MergeReactionFragsAction
extends AbstractReactionFragsAction {
    public MergeReactionFragsAction(SketchPanel panel) {
        super(panel);
    }

    public MergeReactionFragsAction() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getType() != -1) {
            this.getPanel().groupReactionFrags(this.getType());
        }
    }

    @Override
    protected boolean isValidSelection() {
        Sgroup[] sgroups;
        SelectionMolecule sel = this.getEditor().getSelectionMolecule();
        if (sel.getAtomCount() == 1) {
            return false;
        }
        RxnMolecule rxmol = RxnMolecule.getReaction(this.getEditor().getMol());
        for (Sgroup sgroup : sgroups = rxmol.getSgroupArray()) {
            if (!sgroup.isPartSelected(sel)) continue;
            return false;
        }
        long componentID = rxmol.getComponentID(sel.getAtom(0));
        for (int i = 1; i < sel.getAtomCount(); ++i) {
            if (rxmol.getComponentID(sel.getAtom(i)) == componentID) continue;
            return true;
        }
        return false;
    }
}

