/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.structure;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.structure.AbstractReactionFragsAction;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import java.awt.event.ActionEvent;

public class SplitReactionFragsAction
extends AbstractReactionFragsAction {
    public SplitReactionFragsAction(SketchPanel panel) {
        super(panel);
    }

    public SplitReactionFragsAction() {
    }

    @Override
    protected boolean isValidSelection() {
        Sgroup[] sgroups;
        RxnMolecule rxmol = RxnMolecule.getReaction(this.getEditor().getMol());
        SelectionMolecule sel = this.getEditor().getSelectionMolecule();
        for (Sgroup sgroup : sgroups = rxmol.getSgroupArray()) {
            if (!sgroup.isPartSelected(sel)) continue;
            return false;
        }
        for (int i = 0; i < sel.getAtomCount(); ++i) {
            SelectionMolecule[] frags;
            Molecule component = rxmol.getComponent(rxmol.getComponentID(sel.getAtom(i)));
            if (component.getFragCount() <= 1) continue;
            if (component.getRootSgroups().length != 1) {
                return true;
            }
            SelectionMolecule group = component.getSgroup(0).getSgroupGraph();
            for (SelectionMolecule frag : frags = component.findFrags()) {
                int j;
                for (j = 0; j < frag.getAtomCount() && !group.contains(frag.getAtom(j)); ++j) {
                }
                if (j != frag.getAtomCount()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getType() != -1) {
            this.getPanel().groupReactionSplit(this.getType());
        }
    }
}

