/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.template;

import chemaxon.marvin.paint.internal.ColorCollection;
import chemaxon.marvin.uif.resource.IconRepository;
import chemaxon.struc.PeriodicSystem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class AtomIconFactory
implements IconRepository.Factory {
    private static final String LARGE = "large";
    private static String ICON_RESOURCE_BIG = "/chemaxon/icons/marvin/empty24.png";
    private static String ICON_RESOURCE_SMALL = "/chemaxon/icons/marvin/empty16.png";
    private static int ICON_SIZE_BIG = 24;
    private static int ICON_SIZE_SMALL = 16;
    private static int FONT_SIZE_BIG = 13;
    private static int FONT_SIZE_SMALL = 9;
    private static final Font BIG_FONT = new Font("Tahoma", 1, FONT_SIZE_BIG);
    private static final Font SMALL_FONT = new Font("Tahoma", 1, FONT_SIZE_SMALL);
    private static final RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private static ImageIcon smallShape;
    private static ImageIcon bigShape;

    public static void init() {
    }

    private AtomIconFactory() {
    }

    @Override
    public Icon getIcon(String name) {
        int atno;
        URI uri;
        try {
            uri = new URI(name);
        }
        catch (URISyntaxException e) {
            return null;
        }
        String[] names = uri.getSchemeSpecificPart().split("\\.");
        boolean large = names.length > 1 && LARGE.equals(names[1]);
        try {
            atno = Integer.parseInt(names[0]);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
        return large ? this.createIcon(atno, ICON_SIZE_BIG, AtomIconFactory.getBigShape(), BIG_FONT) : this.createIcon(atno, ICON_SIZE_SMALL, AtomIconFactory.getSmallShape(), SMALL_FONT);
    }

    private static ImageIcon getSmallShape() {
        if (smallShape == null) {
            smallShape = AtomIconFactory.loadIcon(ICON_RESOURCE_SMALL);
        }
        return smallShape;
    }

    private static ImageIcon getBigShape() {
        if (bigShape == null) {
            bigShape = AtomIconFactory.loadIcon(ICON_RESOURCE_BIG);
        }
        return bigShape;
    }

    private static ImageIcon loadIcon(String url) {
        return new ImageIcon(AtomIconFactory.class.getResource(url));
    }

    private Icon createIcon(int atno, int size, Icon shape, Font font) {
        Color cpk = ColorCollection.getColor(atno, false);
        String text = PeriodicSystem.getSymbol(atno);
        BufferedImage result = new BufferedImage(size, size, 6);
        Graphics2D g = result.createGraphics();
        if (shape != null) {
            shape.paintIcon(null, g, 0, 0);
        }
        g.setColor(cpk);
        g.setRenderingHints(renderHints);
        g.setFont(font);
        Rectangle2D rect = g.getFontMetrics().getStringBounds(text, g);
        g.drawString(text, (int)(((double)size - rect.getWidth()) / 2.0) + 1, (int)(((double)size - rect.getHeight()) / 2.0) + g.getFontMetrics().getAscent());
        g.dispose();
        return new ImageIcon(result);
    }

    static {
        IconRepository.addRepository("atom", new AtomIconFactory());
    }
}

