/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.template;

import chemaxon.marvin.sketch.AtomSM;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchModeAction;
import chemaxon.marvin.sketch.swing.actions.template.AtomIconFactory;
import chemaxon.marvin.sketch.swing.actions.template.Utils;
import chemaxon.marvin.uif.resource.LazyIcon;
import chemaxon.struc.MolAtom;
import chemaxon.struc.PeriodicSystem;

public class AtomModeAction
extends AbstractSketchModeAction {
    private int atno;
    private int charge;

    protected AtomModeAction(int atno) {
        this(atno, 0);
    }

    protected AtomModeAction(int atno, int charge) {
        this.init(atno, charge);
    }

    protected AtomModeAction(SketchPanel panel, int atno) {
        this(panel, atno, 0);
    }

    protected AtomModeAction(SketchPanel panel, int atno, int charge) {
        super(panel);
        this.init(atno, charge);
        this.update();
    }

    private void init(int atno, int charge) {
        this.atno = atno;
        this.charge = charge;
        if (atno > 0) {
            this.putValue("Name", PeriodicSystem.getName(atno));
            this.putValue("ShortDescription", PeriodicSystem.getName(atno));
            this.putValue("SmallIcon", new LazyIcon("atom:" + atno));
            this.putValue("SwingLargeIconKey", new LazyIcon("atom:" + atno + ".large"));
        }
    }

    @Override
    protected void update() {
        super.update();
        this.setEnabled(this.getEditor().isAllowed(((AtomSM)this.getSketchMode()).getMol()));
    }

    @Override
    protected boolean isModeSelected() {
        SketchMode editorMode = this.getEditor().getSketchMode();
        if (!(editorMode instanceof AtomSM)) {
            return false;
        }
        AtomSM atomSM = (AtomSM)editorMode;
        AtomSM myMode = (AtomSM)this.getSketchMode();
        return Utils.equals(atomSM.getAtom(), myMode.getAtom());
    }

    @Override
    protected SketchMode createSketchMode() {
        MolAtom molAtom = new MolAtom(this.atno);
        molAtom.setElectronProp(-3);
        if (this.charge != 0) {
            molAtom.setCharge(this.charge);
        }
        return new AtomSM(this.getEditor(), molAtom);
    }

    static {
        AtomIconFactory.init();
    }
}

