/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.template;

import chemaxon.marvin.sketch.BondSM;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchModeAction;
import chemaxon.marvin.sketch.swing.actions.template.BondType;
import chemaxon.marvin.sketch.swing.actions.template.Utils;
import chemaxon.marvin.uif.action.DynamicMenuProvider;
import chemaxon.marvin.uif.action.manager.EnumeratedAction2;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import javax.swing.Action;

public class BondModeAction
extends AbstractSketchModeAction
implements DynamicMenuProvider,
EnumeratedAction2<BondType> {
    private static final Action[] NULL_ACTION = new Action[0];
    private MolBond bond;
    private Molecule mol;

    public BondModeAction() {
    }

    public BondModeAction(SketchPanel panel, int flags) {
        this(panel, BondModeAction.createBond(flags));
    }

    public BondModeAction(SketchPanel panel, MolBond bond) {
        super(panel);
        this.init(bond);
    }

    @Override
    public Class<BondType> getType() {
        return BondType.class;
    }

    @Override
    public void setValue(BondType type) {
        this.init(BondModeAction.createBond(type.getValue()));
    }

    private void init(MolBond bond) {
        this.bond = bond;
        this.mol = BondSM.createBondMol(bond.getFlags());
    }

    private static MolBond createBond(int flags) {
        Molecule m = BondSM.createBondMol(flags);
        return m.getBond(0);
    }

    @Override
    protected boolean isModeSelected() {
        if (super.isModeSelected()) {
            return true;
        }
        SketchMode mode = this.getEditor().getSketchMode();
        if (mode == null || mode.getClass() != BondSM.class) {
            return false;
        }
        BondSM currentMode = (BondSM)this.getEditor().getSketchMode();
        MolBond currentBond = currentMode.getMol().getBond(0);
        return Utils.equals(this.bond, currentBond);
    }

    @Override
    protected SketchMode createSketchMode() {
        return new BondSM(this.getEditor(), this.bond);
    }

    @Override
    protected void update() {
        super.update();
        this.setEnabled(this.isAllowed());
    }

    private boolean isAllowed() {
        return this.getEditor().isAllowed(this.mol);
    }

    @Override
    public Action[] getMenuItems() {
        if (!this.isAllowed()) {
            return NULL_ACTION;
        }
        return new Action[]{this};
    }
}

