/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.template;

import chemaxon.marvin.sketch.BondSM;
import chemaxon.marvin.sketch.ChainSM;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchModeAction;
import chemaxon.marvin.uif.action.DynamicMenuProvider;
import chemaxon.marvin.uif.action.manager.EnumeratedAction;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import javax.swing.Action;

public class ChainModeAction
extends AbstractSketchModeAction
implements DynamicMenuProvider,
EnumeratedAction<Integer> {
    private static final long serialVersionUID = -8205394414970452964L;
    private Molecule mol;
    private boolean curvedhainTool;

    public ChainModeAction() {
    }

    public ChainModeAction(SketchPanel panel, int flags) {
        super(panel);
        this.curvedhainTool = flags == 1;
    }

    @Override
    protected SketchMode createSketchMode() {
        return new ChainSM(this.getEditor(), this.curvedhainTool);
    }

    @Override
    protected boolean isModeSelected() {
        SketchMode mode = this.getEditor().getSketchMode();
        if (mode == null || mode.getClass() != ChainSM.class) {
            return false;
        }
        ChainSM currentMode = (ChainSM)this.getEditor().getSketchMode();
        boolean tool = currentMode.getTool();
        return tool == this.curvedhainTool;
    }

    @Override
    protected void update() {
        super.update();
        this.setEnabled(this.isAllowed());
    }

    private boolean isAllowed() {
        return this.getEditor().isAllowed(this.mol);
    }

    public Integer[] getValues() {
        return new Integer[]{0, 1};
    }

    @Override
    public void setValue(Integer value) {
        this.curvedhainTool = value == 1;
        this.init(ChainModeAction.createBond(value));
    }

    private static MolBond createBond(int flags) {
        Molecule m = BondSM.createBondMol(flags);
        return m.getBond(0);
    }

    private void init(MolBond bond) {
        this.mol = BondSM.createBondMol(bond.getFlags());
    }

    @Override
    public Action[] getMenuItems() {
        return new Action[]{this};
    }
}

