/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.template;

import chemaxon.marvin.sketch.AtomSM;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchModeAction;
import chemaxon.marvin.sketch.swing.actions.template.Utils;
import chemaxon.marvin.uif.action.manager.EnumeratedAction;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class LonePairAction
extends AbstractSketchModeAction
implements EnumeratedAction<Integer> {
    private MolAtom atom;
    private Molecule mol;

    public Integer[] getValues() {
        return new Integer[]{-1, 0, 1, 2, 3, 4};
    }

    @Override
    public void setValue(Integer value) {
        this.atom = LonePairAction.createLonePair(value);
        this.mol = new Molecule();
        this.mol.add(this.atom);
    }

    private static MolAtom createLonePair(int flags) {
        MolAtom atom = new MolAtom(0);
        atom.setElectronProp(flags);
        return atom;
    }

    @Override
    protected SketchMode createSketchMode() {
        return new AtomSM(this.getEditor(), this.atom);
    }

    @Override
    protected void update() {
        super.update();
        this.setEnabled(this.isAllowed());
    }

    private boolean isAllowed() {
        return this.getEditor().isAllowed(this.mol);
    }

    @Override
    protected boolean isModeSelected() {
        SketchMode editorMode = this.getEditor().getSketchMode();
        if (!(editorMode instanceof AtomSM)) {
            return false;
        }
        MolAtom smAtom = ((AtomSM)editorMode).getAtom();
        return Utils.equals(smAtom, this.atom) && this.atom.getElectronProp() == smAtom.getElectronProp();
    }
}

