/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.template;

import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MRecordImporter;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchModeAction;
import chemaxon.marvin.util.MolLoader;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class TemplateAction
extends AbstractSketchModeAction {
    private static Map moleculeCache = new HashMap();
    private String resource;
    private boolean templateLoaded;

    public TemplateAction(String resource) {
        this.resource = resource;
        this.templateLoaded = false;
    }

    public TemplateAction(SketchPanel panel, String resource) {
        super(panel);
        this.resource = resource;
    }

    private static synchronized Molecule load(String resource) throws IOException, MRecordParseException {
        if (moleculeCache.containsKey(resource)) {
            return (Molecule)moleculeCache.get(resource);
        }
        Molecule result = TemplateAction.load(TemplateAction.class.getResourceAsStream(resource));
        moleculeCache.put(resource, result);
        return result;
    }

    private static Molecule load(InputStream stream) throws IOException, MRecordParseException {
        MolInputStream mis = new MolInputStream(new BufferedInputStream(stream));
        MRecordImporter mi = MolLoader.createImporter(mis, null);
        MDocument doc = mi.readDoc();
        Molecule result = doc != null ? (Molecule)doc.getMainMoleculeGraph() : null;
        mi.close();
        mis.close();
        TemplateAction.configure(result);
        return result;
    }

    @Override
    protected boolean isModeSelected() {
        return this.templateLoaded && super.isModeSelected();
    }

    private static void configure(Molecule m) {
        if (m.getAtomCount() == 2) {
            int z2;
            MolAtom a1 = m.getAtom(0);
            MolAtom a2 = m.getAtom(1);
            int z1 = a1.getAtno();
            if (z1 == (z2 = a2.getAtno()) && (z1 == 0 || z1 == 6)) {
                a1.setImplicitHcount(0);
                a2.setImplicitHcount(0);
            }
        }
        MoleculeGraph umol = m.getGraphUnion();
        for (int j = 0; j < umol.getAtomCount(); ++j) {
            MolAtom a = umol.getAtom(j);
            a.setFlags(0, 65536);
        }
        DPoint3 cp = m.calcCenter();
        CTransform3D t = new CTransform3D();
        t.setTranslation(-cp.x, -cp.y, -cp.z);
        m.transform(t);
        m.setLocation(new DPoint3(0.0, 0.0, 0.0));
    }

    @Override
    protected SketchMode createSketchMode() {
        try {
            this.templateLoaded = true;
            return this.getEditor().createSM(TemplateAction.load(this.resource));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MRecordParseException e) {
            e.printStackTrace();
        }
        return null;
    }
}

