/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.sketch.swing.AbbrevGroupsDialog;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.FilterUtil;
import chemaxon.marvin.uif.util.swing.AbstractDialog;
import chemaxon.marvin.util.text.StringTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class AbbrevGroupsDialogImpl
extends AbstractDialog
implements AbbrevGroupsDialog {
    private static final long serialVersionUID = 1L;
    private static final String TITLE_KEY = "abbrevGroupsDialog.title";
    private JTree tree1;
    private SketchPanel panel;
    private StringTree tree;
    private JTextField field;

    public AbbrevGroupsDialogImpl(Dialog dialog, SketchPanel panel) {
        super((Window)dialog, "", false);
        this.panel = panel;
    }

    public AbbrevGroupsDialogImpl(Frame frame, SketchPanel panel) {
        super((Window)frame, "", false);
        this.panel = panel;
    }

    @Override
    public void setNames(String[] names) {
        this.setStringTree(new StringTree(names, 16));
    }

    public void setStringTree(StringTree tree) {
        this.tree = tree;
        ResourceBundle bundle = MolPanel.getResourceBundle(AbbrevGroupsDialogImpl.class.getName());
        this.setTitle(bundle.getString(TITLE_KEY));
    }

    @Override
    public void open() {
        super.open();
        if (this.tree1 != null) {
            FilterUtil.release(this.tree1);
            this.field.setText("type filter text");
            this.field.selectAll();
            FilterUtil.bind(this.tree1, this.field);
        }
    }

    private void treeValueChanged() {
        Object o = this.tree1.getLastSelectedPathComponent();
        if (!this.tree1.getModel().isLeaf(o)) {
            return;
        }
        this.panel.selectAbbrevGroup(AbbrevGroupsDialogImpl.convertNode(o));
    }

    @Override
    protected JComponent buildContentPanel() {
        this.field = new JTextField();
        JPanel contentPanel = new JPanel();
        JScrollPane scrollPane1 = new JScrollPane();
        this.tree1 = new JTree();
        this.tree1.addMouseListener(new MouseHandler());
        this.tree1.getActionMap().put("close", this.getCloseAction());
        this.tree1.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "close");
        this.tree1.setCellRenderer(new Renderer());
        contentPanel.setLayout(new BorderLayout());
        this.tree1.setShowsRootHandles(true);
        this.tree1.setRootVisible(false);
        this.tree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AbbrevGroupsDialogImpl.this.treeValueChanged();
            }
        });
        scrollPane1.setViewportView(this.tree1);
        scrollPane1.setPreferredSize(new Dimension(300, 200));
        contentPanel.add((Component)this.field, "North");
        contentPanel.add((Component)scrollPane1, "Center");
        this.tree1.setModel(new StringTreeAdapter(this.tree));
        return contentPanel;
    }

    @Override
    protected JComponent buildButtonBar() {
        return this.buildCloseButtonBar();
    }

    private static String convertNode(Object o) {
        return o instanceof StringTree ? ((StringTree)o).getLabel() : o.toString();
    }

    private static class Renderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        private Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasfocus) {
            value = AbbrevGroupsDialogImpl.convertNode(value);
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasfocus);
        }
    }

    private static class StringTreeAdapter
    implements TreeModel {
        private StringTree root;

        public StringTreeAdapter(StringTree root) {
            this.root = root;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public Object getChild(Object parent, int index) {
            return ((StringTree)parent).get(index);
        }

        @Override
        public int getChildCount(Object parent) {
            if (this.isLeaf(parent)) {
                return 0;
            }
            return ((StringTree)parent).length();
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (this.isLeaf(parent) || child == null) {
                return -1;
            }
            StringTree node = (StringTree)parent;
            for (int i = 0; i < node.length(); ++i) {
                if (!child.equals(node.get(i))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public boolean isLeaf(Object node) {
            return node instanceof String;
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && e.getButton() == 1) {
                AbbrevGroupsDialogImpl.this.close();
            }
        }
    }
}

