/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.sketch.AtomSM;
import chemaxon.marvin.sketch.swing.modules.SketchToggleButton;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;

public class AtomButton
extends SketchToggleButton {
    private static String ICON_RESOURCE_BIG = "/chemaxon/icons/marvin/empty24.png";
    private static String ICON_RESOURCE_SMALL = "/chemaxon/icons/marvin/empty16.png";
    private static int ICON_SIZE_BIG = 24;
    private static int ICON_SIZE_SMALL = 16;
    private static int FONT_SIZE_BIG = 13;
    private static int FONT_SIZE_SMALL = 9;
    private static boolean bigIcon = true;
    private static Color highlightColor = new Color(252, 163, 17, 105);
    private Color backgroundColor;
    private Color foregroundColor;
    static ImageIcon iconShape = null;
    static Font bigFont = new Font("Tahoma", 1, FONT_SIZE_BIG);
    static Font smallFont = new Font("Tahoma", 1, FONT_SIZE_SMALL);
    static RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private int atNo = 0;
    private String label = "";

    public AtomButton(String label, boolean icon, int atNo, AtomSM so) {
        super(label, so.getMol());
        this.atNo = atNo;
        this.label = label;
        if (icon) {
            AtomButton.setIconImage();
            this.setIcon();
            this.setText(null);
        } else {
            this.setText(label);
        }
    }

    public int getAtNo() {
        return this.atNo;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public void updateIcon() {
        this.setIcon();
    }

    private static void setIconImage() {
        try {
            URL u = AtomButton.class.getResource(AtomButton.getIconResource());
            if (u != null) {
                iconShape = new ImageIcon(u);
            } else {
                System.err.println("null icon");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setIcon() {
        BufferedImage image = new BufferedImage(AtomButton.getIconSize(), AtomButton.getIconSize(), 6);
        this.drawIcon(image, this.label, false);
        BufferedImage image2 = new BufferedImage(AtomButton.getIconSize(), AtomButton.getIconSize(), 6);
        this.drawIcon(image2, this.label, true);
        this.setIcon(new ImageIcon(image));
        this.setSelectedIcon(new ImageIcon(image2));
        this.setBorder(null);
    }

    private void drawIcon(Image image, String text, boolean highlight) {
        Graphics g = image.getGraphics();
        if (iconShape != null) {
            g.drawImage(iconShape.getImage(), 0, 0, iconShape.getIconWidth(), iconShape.getIconHeight(), null);
        }
        int iconSize = AtomButton.getIconSize();
        if (highlight) {
            g.setColor(highlightColor);
            g.fillRect(0, 0, iconSize, iconSize);
        } else {
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, iconSize, iconSize);
        }
        g.setColor(this.foregroundColor);
        ((Graphics2D)g).setRenderingHints(renderHints);
        g.setFont(AtomButton.getUsedFont());
        Rectangle2D rect = g.getFontMetrics().getStringBounds(text, g);
        g.drawString(text, (int)(((double)iconSize - rect.getWidth()) / 2.0) + 1, (int)(((double)iconSize - rect.getHeight()) / 2.0) + g.getFontMetrics().getAscent());
    }

    private static int getIconSize() {
        return bigIcon ? ICON_SIZE_BIG : ICON_SIZE_SMALL;
    }

    private static String getIconResource() {
        return bigIcon ? ICON_RESOURCE_BIG : ICON_RESOURCE_SMALL;
    }

    private static Font getUsedFont() {
        return bigIcon ? bigFont : smallFont;
    }

    public void setLargeIcon(boolean b) {
        bigIcon = b;
        if (iconShape != null) {
            AtomButton.setIconImage();
            this.setIcon();
        }
    }
}

