/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.enumeration.homology.HomologyPropertyTypes;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.atompropertyeditor.PresentationChooser;
import chemaxon.marvin.sketch.swing.modules.atompropertyeditor.PresentationChooserImpl;
import chemaxon.marvin.sketch.swing.modules.atompropertyeditor.editors.PropertyValidationSupport;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.MolAtom;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class AtomPropertyEditorDialog
implements CallbackIface,
ActionListener {
    private SketchPanel sketchPanel;
    private MolAtom atom = null;
    private JDialog dialog = null;

    @Override
    public Object callback(String method, Object arg) {
        if ("setSketchPanel".equals(method)) {
            this.sketchPanel = (SketchPanel)arg;
        } else if ("setAtom".equals(method)) {
            this.atom = (MolAtom)arg;
        } else if ("show".equals(method)) {
            PresentationChooser presentationChooser = null;
            Object value = this.sketchPanel.getClientProperty("chemaxon.marvin.sketch.swing.atompropertyeditor.PresentationChooser");
            if (value instanceof PresentationChooser) {
                presentationChooser = (PresentationChooser)value;
            }
            if (presentationChooser == null) {
                presentationChooser = new PresentationChooserImpl();
                this.sketchPanel.putClientProperty("chemaxon.marvin.sketch.swing.atompropertyeditor.PresentationChooser", presentationChooser);
            }
            this.init(arg != null && arg instanceof PresentationChooser ? (PresentationChooser)arg : presentationChooser);
            this.dialog.pack();
            try {
                Method m = JDialog.class.getMethod("setLocationRelativeTo", Component.class);
                m.invoke((Object)this.dialog, this.sketchPanel);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    AtomPropertyEditorDialog.this.showDialog();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
        return null;
    }

    private void init(final PresentationChooser presentationChooser) {
        FormLayout layout = new FormLayout("4dlu, fill:min:grow, min, 2dlu, min, fill:min:grow, 4dlu", "4dlu, fill:min:grow, 2dlu, min, 4dlu");
        layout.setColumnGroups((int[][])new int[][]{{3, 5}});
        this.dialog = this.sketchPanel.isParentWindowDialog() ? new JDialog(this.sketchPanel.getParentDialog()) : new JDialog(this.sketchPanel.getParentFrame());
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AtomPropertyEditorDialog.this.sketchPanel.requestFocus();
            }
        });
        String mapInfo = this.atom.getAtomMap() == 0 ? "" : " #" + this.atom.getAtomMap();
        this.dialog.setTitle("Edit properties of atom" + mapInfo + " (" + this.atom.getSymbol() + ")");
        this.dialog.getContentPane().setLayout((LayoutManager)layout);
        final JTable table = new JTable(new DefaultTableModel(new Object[]{"Property key", "Property value"}, 0)){

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                String propertyName = this.getModel().getValueAt(row, 0) == null ? "" : this.getModel().getValueAt(row, 0).toString();
                TableCellEditor editor = null;
                if (column == 0) {
                    editor = presentationChooser.getPropertyKeyEditor(propertyName);
                } else if (row + 1 != this.getRowCount()) {
                    editor = presentationChooser.getPropertyValueEditor(propertyName);
                }
                return editor;
            }

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                String propertyName;
                String string = propertyName = this.getModel().getValueAt(row, 0) == null ? "" : this.getModel().getValueAt(row, 0).toString();
                if (column == 0) {
                    return presentationChooser.getPropertyKeyRenderer(propertyName);
                }
                return presentationChooser.getPropertyValueRenderer(propertyName);
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                int row = this.getEditingRow();
                int col = this.getEditingColumn();
                super.editingStopped(e);
                if (this.getValueAt(row, 0) == null || this.getValueAt(row, 0).toString().equals("")) {
                    ((DefaultTableModel)this.getModel()).removeRow(row);
                } else if (col == 0) {
                    String newKeyBase;
                    String newKey = newKeyBase = this.getValueAt(row, col).toString();
                    boolean match = true;
                    int count = 1;
                    while (match) {
                        match = false;
                        for (int i = 0; i < this.getRowCount() && !match; ++i) {
                            if (!newKey.equals(this.getValueAt(i, 0)) || i == row) continue;
                            match = true;
                            newKey = newKeyBase + ++count;
                        }
                    }
                    this.setValueAt(newKey, row, 0);
                }
                if (this.getValueAt(this.getRowCount() - 1, 0) != null) {
                    ((DefaultTableModel)this.getModel()).addRow(new Object[]{null, null});
                }
            }
        };
        for (Map.Entry<String, Object> entry : this.atom.propertySet()) {
            ((DefaultTableModel)table.getModel()).addRow(new Object[]{entry.getKey(), entry.getValue()});
        }
        String[] reserved = HomologyPropertyTypes.getApplicableReservedPropertyNames(this.atom);
        for (int i = 0; i < reserved.length; ++i) {
            if (this.atom.containsPropertyKey(reserved[i])) continue;
            ((DefaultTableModel)table.getModel()).addRow(new Object[]{reserved[i], null});
        }
        Vector<Vector> vector = ((DefaultTableModel)table.getModel()).getDataVector();
        Collections.sort(vector, new Comparator<Vector<?>>(){

            @Override
            public int compare(Vector<?> o1, Vector<?> o2) {
                if (o1.get(0) instanceof Comparable && o2.get(0) instanceof Comparable) {
                    return ((Comparable)o1.get(0)).compareTo((Comparable)o2.get(0));
                }
                return 0;
            }
        });
        ((DefaultTableModel)table.getModel()).fireTableStructureChanged();
        ((DefaultTableModel)table.getModel()).addRow(new Object[]{null, null});
        CellConstraints cc = new CellConstraints();
        JScrollPane scroll = new JScrollPane(table, 20, 31);
        scroll.getViewport().setBackground(table.getBackground());
        scroll.setMinimumSize(new Dimension(100, 200));
        final JButton okButton = new JButton(new AbstractAction("Ok"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor editor = table.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                }
                AtomPropertyEditorDialog.this.atom.clearProperties();
                for (int i = 0; i < table.getRowCount(); ++i) {
                    if (table.getValueAt(i, 0) == null) continue;
                    AtomPropertyEditorDialog.this.atom.putProperty((String)table.getValueAt(i, 0), table.getValueAt(i, 1));
                }
                AtomPropertyEditorDialog.this.dialog.setVisible(false);
            }
        });
        JButton cancelButton = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AtomPropertyEditorDialog.this.dialog.setVisible(false);
            }
        });
        table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                boolean valid = true;
                for (int i = 0; i < table.getRowCount() && valid; ++i) {
                    TableCellEditor editor = table.getCellEditor(i, 1);
                    if (editor == null || !(editor instanceof PropertyValidationSupport)) continue;
                    valid = ((PropertyValidationSupport)((Object)editor)).isValid();
                }
                if (okButton != null) {
                    okButton.setEnabled(valid);
                }
            }
        });
        this.dialog.getContentPane().add((Component)scroll, cc.xyw(2, 2, 5));
        this.dialog.getContentPane().add((Component)okButton, cc.xy(3, 4));
        this.dialog.getContentPane().add((Component)cancelButton, cc.xy(5, 4));
    }

    private void showDialog() {
        this.dialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

