/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.templates.TemplateHandler;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.Molecule;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DockDropTarget
extends DropTargetAdapter
implements CallbackIface {
    private Object panel;
    private JPanel canvas;
    private JPanel dockPane;
    private DropTarget target;

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("init")) {
            Object[] arguments = (Object[])arg;
            this.panel = arguments[0];
            this.dockPane = (JPanel)arguments[1];
            this.canvas = (JPanel)arguments[2];
            this.target = new DropTarget(this.dockPane, this);
            this.dockPane.setDropTarget(this.target);
        }
        return null;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (this.getTemplateHandler() != null && (dtde.getDropAction() & 3) != 0) {
            dtde.acceptDrop(dtde.getDropAction());
            Transferable t = dtde.getTransferable();
            Molecule dropMol = (Molecule)ClipboardHandler.getObjectFromTransferable(t);
            if (dropMol != null) {
                this.getTemplateHandler().addToMyTemplates(dropMol);
                dtde.dropComplete(true);
            } else {
                dtde.dropComplete(false);
            }
        } else {
            dtde.rejectDrop();
        }
    }

    private TemplateHandler getTemplateHandler() {
        return ((SketchPanel)this.panel).getTemplateHandler();
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.handleDragEvent(dtde);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        this.handleDragEvent(dtde);
    }

    private void handleDragEvent(DropTargetDragEvent dtde) {
        if (this.isValidLocation(dtde.getLocation())) {
            dtde.acceptDrag(3);
        } else {
            dtde.rejectDrag();
        }
    }

    private boolean isValidLocation(Point location) {
        return this.getTemplateHandler() != null && this.getTemplateHandler().getTemplateToolBar().isShowing() && this.getDockRectangle(this.getTemplateHandler().getTemplateToolBar()).contains(location);
    }

    private Rectangle getDockRectangle(JComponent component) {
        Rectangle rect = new Rectangle();
        Rectangle bounds = component.getBounds();
        if (this.getNorth(rect).contains(bounds)) {
            return rect;
        }
        if (this.getSouth(rect).contains(bounds)) {
            return rect;
        }
        if (this.getWest(rect).contains(bounds)) {
            return rect;
        }
        if (this.getEast(rect).contains(bounds)) {
            return rect;
        }
        return new Rectangle(-1, -1);
    }

    private Rectangle getNorth(Rectangle rect) {
        rect.x = this.dockPane.getX();
        rect.y = this.dockPane.getY();
        rect.height = this.canvas.getX() - rect.x;
        rect.width = this.dockPane.getHeight();
        return rect;
    }

    private Rectangle getSouth(Rectangle rect) {
        rect.x = this.dockPane.getX();
        rect.y = this.canvas.getY() + this.canvas.getHeight();
        rect.width = this.dockPane.getWidth();
        rect.height = this.dockPane.getY() + this.dockPane.getHeight() - rect.y;
        return rect;
    }

    private Rectangle getWest(Rectangle rect) {
        rect.x = this.dockPane.getX();
        rect.y = this.canvas.getY();
        rect.width = this.canvas.getX() - rect.x;
        rect.height = this.canvas.getHeight();
        return rect;
    }

    private Rectangle getEast(Rectangle rect) {
        rect.x = this.canvas.getX() + this.canvas.getWidth();
        rect.y = this.canvas.getY();
        rect.width = this.dockPane.getX() + this.dockPane.getWidth() - rect.x;
        rect.height = this.canvas.getHeight();
        return rect;
    }
}

