/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class FlowScrollLayout
extends FlowLayout
implements ComponentListener,
ContainerListener {
    private JScrollPane scroller = null;
    private boolean uniformHeight;
    private boolean firstTime = true;

    public FlowScrollLayout() {
        this(null, null);
    }

    public FlowScrollLayout(Container target) {
        this(null, target);
    }

    public FlowScrollLayout(JScrollPane scrollPane) {
        this(scrollPane, null, false);
    }

    public FlowScrollLayout(JScrollPane scrollPane, Container target) {
        this(scrollPane, target, false);
    }

    public FlowScrollLayout(JScrollPane scrollPane, Container target, boolean uniformHeight) {
        super(3);
        this.setScrollPane(scrollPane);
        this.uniformHeight = uniformHeight;
        if (target != null) {
            target.addContainerListener(this);
        }
    }

    public void setScrollPane(JScrollPane scrollPane) {
        if (scrollPane != this.scroller) {
            if (this.scroller != null) {
                this.scroller.removeComponentListener(this);
            }
            this.scroller = scrollPane;
            if (this.scroller != null) {
                this.scroller.addComponentListener(this);
            }
        }
    }

    public void setUniformHeight(boolean on) {
        if (this.uniformHeight != on) {
            this.uniformHeight = on;
            if (this.scroller != null) {
                this.scroller.doLayout();
            }
        }
    }

    public boolean isUniformHeight() {
        return this.uniformHeight;
    }

    protected Dimension computeDesiredSize() {
        JViewport viewport = this.scroller.getViewport();
        Dimension extent = viewport.getExtentSize();
        Component child = viewport.getView();
        if (child instanceof Container) {
            Container container = (Container)child;
            Insets insets = container.getInsets();
            int vgap = this.getVgap();
            int hgap = this.getHgap();
            int maxAllowedWidth = extent.width - (insets.left + insets.right + hgap * 2);
            int numComponents = container.getComponentCount();
            int x = 0;
            int y = insets.top + vgap;
            int rowh = 0;
            int maxRowWidth = 0;
            int start = 0;
            for (int i = 0; i < numComponents; ++i) {
                Component comp = container.getComponent(i);
                if (!comp.isVisible()) continue;
                Dimension dim = comp.getPreferredSize();
                if (x == 0 || x + dim.width <= maxAllowedWidth) {
                    if (x > 0) {
                        x += hgap;
                    }
                    x += dim.width;
                    rowh = Math.max(rowh, dim.height);
                    continue;
                }
                if (this.uniformHeight) {
                    FlowScrollLayout.setHeights(container, rowh, start, i);
                }
                if (x > maxRowWidth - hgap) {
                    maxRowWidth = x + hgap;
                }
                x = dim.width;
                y += vgap + rowh;
                rowh = dim.height;
                start = i;
            }
            if (this.uniformHeight) {
                FlowScrollLayout.setHeights(container, rowh, start, numComponents);
            }
            if (x > maxRowWidth - hgap) {
                maxRowWidth = x + hgap;
            }
            return new Dimension(maxRowWidth, y += vgap + rowh + insets.bottom);
        }
        if (child != null) {
            Dimension prefSize = child.getPreferredSize();
            return new Dimension(extent.width, prefSize.height);
        }
        return null;
    }

    public static void setHeights(Container container, int height, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            Component comp = container.getComponent(i);
            if (!(comp instanceof JComponent)) continue;
            FlowScrollLayout.setPreferredHeight((JComponent)comp, height);
        }
    }

    public static void setPreferredHeight(JComponent comp, int height) {
        Dimension prefSize = comp.getPreferredSize();
        prefSize.height = height;
        comp.setPreferredSize(prefSize);
    }

    protected void updateLayout() {
        if (this.scroller != null) {
            JViewport viewport = this.scroller.getViewport();
            Dimension viewSize = viewport.getViewSize();
            Dimension extentSize = viewport.getExtentSize();
            Dimension desiredSize = this.computeDesiredSize();
            if (desiredSize != null && (viewSize.width != extentSize.width || viewSize.height != desiredSize.height)) {
                Dimension newSize = new Dimension(Math.max(desiredSize.width, extentSize.width), Math.max(desiredSize.height, extentSize.height));
                Component child = viewport.getView();
                if (child instanceof JComponent) {
                    ((JComponent)child).setPreferredSize(newSize);
                }
                viewport.setViewSize(newSize);
                if (!this.firstTime) {
                    child.doLayout();
                    this.scroller.doLayout();
                }
            }
        }
    }

    @Override
    public void layoutContainer(Container c) {
        if (this.firstTime) {
            this.updateLayout();
            this.firstTime = false;
        }
        super.layoutContainer(c);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateLayout();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.updateLayout();
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this.updateLayout();
    }
}

