/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.FormatMoleculePanel;
import chemaxon.marvin.sketch.swing.modules.MObjectPropertiesPanel;
import chemaxon.marvin.swing.DelegatingAction;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.MObject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class FormatDialog
implements CallbackIface,
ActionListener {
    private static final String CANCEL_COMMAND = "cancel";
    private static final String OK_COMMAND = "ok";
    private SketchPanel sketchPanel;
    private JDialog dialog = null;
    private Object molecule = null;
    private MObject[] mObjects = null;
    private FormatMoleculePanel moleculePanel;
    private MObjectPropertiesPanel mObjPropsPanel;
    private ResourceBundle resources = ResourceBundle.getBundle(FormatDialog.class.getName());

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("setSketchPanel")) {
            this.setSketchPanel((SketchPanel)arg);
        } else if (method.equals("setMolecule")) {
            this.setMolecule(arg);
        } else if (method.equals("setMObjects")) {
            this.setMObjects((MObject[])arg);
        } else if (method.equals("show")) {
            this.show();
        }
        return null;
    }

    public void setMObjects(MObject[] objects) {
        this.mObjects = (MObject[])objects.clone();
    }

    public void setMolecule(Object arg) {
        this.molecule = arg;
    }

    public void setSketchPanel(SketchPanel arg) {
        this.sketchPanel = arg;
    }

    public void show() {
        this.init();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.sketchPanel);
        this.dialog.setVisible(true);
    }

    private void init() {
        this.dialog = this.sketchPanel.isParentWindowDialog() ? new JDialog(this.sketchPanel.getParentDialog()) : new JDialog(this.sketchPanel.getParentFrame());
        this.dialog.setResizable(false);
        this.dialog.setTitle(this.resources.getString("FormatDialog"));
        this.dialog.getContentPane().setLayout(new BoxLayout(this.dialog.getContentPane(), 1));
        this.dialog.getContentPane().add(this.createContent());
        this.dialog.getContentPane().add(this.createOkCancelPanel());
    }

    public JComponent createContent() {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.moleculePanel = new FormatMoleculePanel(this.sketchPanel, this.molecule, this.dialog);
        this.mObjPropsPanel = new MObjectPropertiesPanel(this.sketchPanel, this.mObjects, this.dialog);
        tabbedPane.add(this.resources.getString("Molecule"), this.moleculePanel);
        tabbedPane.add(this.resources.getString("Graphics"), this.mObjPropsPanel);
        return tabbedPane;
    }

    private JPanel createOkCancelPanel() {
        JPanel panel = new JPanel();
        panel.add(this.createButton(OK_COMMAND));
        panel.add(this.createButton(CANCEL_COMMAND));
        return panel;
    }

    public JButton createButton(String command) {
        DelegatingAction action = new DelegatingAction(command, MolPanel.GRESOURCES.getString(command));
        action.addActionListener(this);
        return new JButton(action);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (OK_COMMAND.equals(ev.getActionCommand())) {
            this.apply();
        } else if (CANCEL_COMMAND.equals(ev.getActionCommand())) {
            this.cancel();
        }
    }

    private void cancel() {
        this.dialog.setVisible(false);
    }

    private void apply() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.moleculePanel.applyChanges();
        this.mObjPropsPanel.performChanges();
        this.sketchPanel.getEditor().historize();
        this.sketchPanel.repaint();
    }
}

