/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.sketch.AtomSM;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;

public class GenericsActionFactory {
    public static final int A = 0;
    public static final int AH = 1;
    public static final int Q = 2;
    public static final int QH = 3;
    public static final int M = 4;
    public static final int MH = 5;
    public static final int X = 6;
    public static final int XH = 7;
    public static final int G = 8;
    public static final int GH = 9;
    public static final int G_ = 10;
    public static final int GH_ = 11;
    public static final int ACY = 12;
    public static final int ACH = 13;
    public static final int CYC = 14;
    public static final int CYH = 15;
    public static final int ABC = 16;
    public static final int ABH = 17;
    public static final int AHC = 18;
    public static final int AHH = 19;
    public static final int CBC = 20;
    public static final int CBH = 21;
    public static final int CHC = 22;
    public static final int CHH = 23;
    public static final int CXX = 24;
    public static final int CXH = 25;
    public static final int AYL = 26;
    public static final int AYH = 27;
    public static final int ALK = 28;
    public static final int ALH = 29;
    public static final int AEL = 30;
    public static final int AEH = 31;
    public static final int AOX = 32;
    public static final int AOH = 33;
    public static final int ARY = 34;
    public static final int ARH = 35;
    public static final int CAL = 36;
    public static final int CAH = 37;
    public static final int CEL = 38;
    public static final int CEH = 39;
    public static final int HAR = 40;
    public static final int HAH = 41;
    public static String[] genericsNames = new String[]{"A", "AH", "Q", "QH", "M", "MH", "X", "XH", "G", "GH", "G*", "GH*", "ACY", "ACH", "CYC", "CYH", "ABC", "ABH", "AHC", "AHH", "CBC", "CBH", "CHC", "CHH", "CXX", "CXH", "AYL", "AYH", "ALK", "ALH", "AEL", "AEH", "AOX", "AOH", "ARY", "ARH", "CAL", "CAH", "CEL", "CEH", "HAR", "HAH"};
    public static String[] genericsHelpTexts = new String[]{"Any atom except hydrogen", "Any atom", "Any atom except carbon and hydrogen", "Any atom except carbon", "Any metal", "Any metal or hydrogen", "Any halogen", "Any halogen or hydrogen", "Any group", "Any group or hydrogen", "Any group; ring closure between groups allowed", "Any group or hydrogen; ring closure between groups allowed", "Acyclic", "Acyclic or hydrogen", "Cyclic", "Cyclic or hydrogen", "Carbacyclic", "Carbacyclic or hydrogen", "Heteroacyclic", "Heteroacyclic or hydrogen", "Carbocyclic", "Carbocyclic or hydrogen", "Heterocyclic", "Heterocyclic or hydrogen", "Any cyclic group with no carbon", "Any cyclic group with no carbon or hydrogen", "Alkynyl", "Alkynyl or hydrogen", "Alkyl", "Alkyl or hydrogen", "Akenyl", "Akenyl or hydrogen", "Alkoxy", "Alkoxy or hydrogen", "Aryl", "Aryl or hydrogen", "Cycloalkyl", "Cycloalkyl or hydrogen", "Cycloalkenyl", "Cycloalkenyl or hydrogen", "Heteroaryl", "Heteroaryl or hydrogen"};
    private SketchPanel panel;

    public GenericsActionFactory(SketchPanel panel) {
        this.panel = panel;
    }

    public Action createGenericsAction(int generics) {
        MolAtom atom = new MolAtom(0);
        atom.setAtno(136);
        atom.setAliasstr(genericsNames[generics]);
        AtomSM sketchMode = new AtomSM(this.panel.getEditor(), atom);
        return new GenericGroupAction(genericsNames[generics], sketchMode.getMol(), this.panel);
    }

    public JToggleButton createGenericsButton(int generics, ButtonGroup buttonGroup) {
        JToggleButton button = new JToggleButton(this.createGenericsAction(generics));
        button.setMargin(new Insets(2, 2, 2, 2));
        button.setToolTipText(genericsHelpTexts[generics]);
        buttonGroup.add(button);
        return button;
    }

    private class GenericGroupAction
    extends AbstractAction {
        private Molecule mol;
        private final SketchPanel sketcher;

        public GenericGroupAction(String name, Molecule mol, SketchPanel panel) {
            super(name);
            this.mol = null;
            this.mol = mol;
            this.sketcher = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SketchMode sketchMode = this.sketcher.getEditor().createSM(this.mol);
            DPoint3 center = this.mol.calcCenter();
            this.mol.setLocation(center);
            this.sketcher.setSketchMode(sketchMode, false, false, true, true);
        }
    }
}

