/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.sketch.swing.modules.GenericsActionFactory;
import chemaxon.marvin.sketch.swing.modules.GenericsLayoutStrategy;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class GenericsBoxedLayout
implements GenericsLayoutStrategy {
    ButtonGroup buttonGroup;
    GenericsActionFactory factory;
    DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();

    @Override
    public JPanel createPanel(GenericsActionFactory factory) {
        this.factory = factory;
        JPanel genericsPanel = new JPanel();
        CellConstraints cc = new CellConstraints();
        this.buttonGroup = new ButtonGroup();
        genericsPanel.setLayout(new BorderLayout());
        this.createAtomGenerics(genericsPanel, cc);
        this.createGroupGenericsPanel(genericsPanel, cc);
        return genericsPanel;
    }

    private void createAtomGenerics(JPanel genericsPanel, CellConstraints cc) {
        JPanel atomGenericsPanel = new JPanel();
        atomGenericsPanel.setBorder(new CompoundBorder(new TitledBorder(null, "Atom Generics", 2, 2), new EmptyBorder(2, 2, 2, 2)));
        atomGenericsPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(default;20dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(default;20dlu)"), FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec("max(default;20dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(default;20dlu)"), FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec("max(default;20dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(default;20dlu)"), FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec("max(default;20dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(default;20dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, RowSpec.decodeSpecs((String)"default")));
        for (int i = 0; i < 8; ++i) {
            JToggleButton button = this.factory.createGenericsButton(i, this.buttonGroup);
            atomGenericsPanel.add((Component)button, cc.xy(3 + i * 2, 1));
        }
        genericsPanel.add((Component)atomGenericsPanel, "North");
    }

    private JPanel createGroupGenericsPanel(JPanel genericsPanel, CellConstraints cc) {
        JPanel groupGenericsPanel = this.createBorderedPanel("Group Generics", 3, 3);
        this.createAnyGroupGenerics(groupGenericsPanel, cc);
        this.createAcyclicGroupGenerics(groupGenericsPanel, cc);
        this.createCyclicGroupGenerics(groupGenericsPanel, cc);
        genericsPanel.add((Component)groupGenericsPanel, "Center");
        return groupGenericsPanel;
    }

    private void createAnyGroupGenerics(JPanel genericsPanel, CellConstraints cc) {
        this.createGroupGenerics(genericsPanel, cc, 8, 12, 1, 1, 3, 1);
    }

    private void createAcyclicGroupGenerics(JPanel genericsPanel, CellConstraints cc) {
        JPanel acyclicPanel = this.createBorderedPanel("Acyclic", 3, 3);
        this.createGroupGenerics(acyclicPanel, cc, 12, 14, 1, 1, 3, 1);
        this.createCarbacyclicGroupGenerics(acyclicPanel, cc);
        this.createHeteroacyclicGroupGenerics(acyclicPanel, cc);
        genericsPanel.add((Component)acyclicPanel, cc.xy(1, 3));
    }

    private void createCarbacyclicGroupGenerics(JPanel genericsPanel, CellConstraints cc) {
        JPanel panel = this.createBorderedPanel("Carbacyclic", 5, 7);
        this.createGroupGenerics(panel, cc, 16, 18, 1, 1, 5, 1);
        panel.add((Component)this.compFactory.createLabel("Alkynyl:"), cc.xy(1, 3));
        panel.add((Component)this.factory.createGenericsButton(26, this.buttonGroup), cc.xy(3, 3));
        panel.add((Component)this.factory.createGenericsButton(27, this.buttonGroup), cc.xy(5, 3));
        panel.add((Component)this.compFactory.createLabel("Alkyl:"), cc.xy(1, 5));
        panel.add((Component)this.factory.createGenericsButton(28, this.buttonGroup), cc.xy(3, 5));
        panel.add((Component)this.factory.createGenericsButton(29, this.buttonGroup), cc.xy(5, 5));
        panel.add((Component)this.compFactory.createLabel("Alkenyl:"), cc.xy(1, 7));
        panel.add((Component)this.factory.createGenericsButton(30, this.buttonGroup), cc.xy(3, 7));
        panel.add((Component)this.factory.createGenericsButton(31, this.buttonGroup), cc.xy(5, 7));
        genericsPanel.add((Component)panel, cc.xy(1, 3));
    }

    private void createHeteroacyclicGroupGenerics(JPanel genericsPanel, CellConstraints cc) {
        JPanel panel = this.createBorderedPanel("Hetero acyclic", 5, 5);
        panel.setBorder(new TitledBorder(null, "Hetero acyclic", 2, 0));
        this.createGroupGenerics(panel, cc, 18, 20, 1, 1, 5, 1);
        panel.add((Component)this.compFactory.createLabel("Alkoxy:"), cc.xy(1, 3));
        panel.add((Component)this.factory.createGenericsButton(32, this.buttonGroup), cc.xy(3, 3));
        panel.add((Component)this.factory.createGenericsButton(33, this.buttonGroup), cc.xy(5, 3));
        genericsPanel.add((Component)panel, cc.xy(3, 3));
    }

    private void createCyclicGroupGenerics(JPanel genericsPanel, CellConstraints cc) {
        JPanel cyclicPanel = this.createBorderedPanel("Cyclic", 5, 3);
        this.createGroupGenerics(cyclicPanel, cc, 14, 16, 1, 1, 5, 1);
        this.createCarbocyclicGroupGenerics(cyclicPanel, cc);
        this.createHeterocyclicGroupGenerics(cyclicPanel, cc);
        this.createNoCarbonGroupGenerics(cyclicPanel, cc);
        genericsPanel.add((Component)cyclicPanel, cc.xy(3, 3));
    }

    private void createCarbocyclicGroupGenerics(JPanel genericsPanel, CellConstraints cc) {
        JPanel panel = this.createBorderedPanel("Carbocyclic", 5, 7);
        this.createGroupGenerics(panel, cc, 20, 22, 1, 1, 5, 1);
        panel.add((Component)this.compFactory.createLabel("Aryl:"), cc.xy(1, 3));
        panel.add((Component)this.factory.createGenericsButton(34, this.buttonGroup), cc.xy(3, 3));
        panel.add((Component)this.factory.createGenericsButton(35, this.buttonGroup), cc.xy(5, 3));
        panel.add((Component)this.compFactory.createLabel("Cycloalkyl:"), cc.xy(1, 5));
        panel.add((Component)this.factory.createGenericsButton(36, this.buttonGroup), cc.xy(3, 5));
        panel.add((Component)this.factory.createGenericsButton(37, this.buttonGroup), cc.xy(5, 5));
        panel.add((Component)this.compFactory.createLabel("Cycloalkenyl:"), cc.xy(1, 7));
        panel.add((Component)this.factory.createGenericsButton(38, this.buttonGroup), cc.xy(3, 7));
        panel.add((Component)this.factory.createGenericsButton(39, this.buttonGroup), cc.xy(5, 7));
        genericsPanel.add((Component)panel, cc.xy(1, 3));
    }

    private void createHeterocyclicGroupGenerics(JPanel genericsPanel, CellConstraints cc) {
        JPanel panel = this.createBorderedPanel("Heterocyclic", 5, 5);
        this.createGroupGenerics(panel, cc, 22, 24, 1, 1, 5, 1);
        panel.add((Component)this.compFactory.createLabel("Hetero aryl:"), cc.xy(1, 3));
        panel.add((Component)this.factory.createGenericsButton(40, this.buttonGroup), cc.xy(3, 3));
        panel.add((Component)this.factory.createGenericsButton(41, this.buttonGroup), cc.xy(5, 3));
        genericsPanel.add((Component)panel, cc.xy(3, 3));
    }

    private void createNoCarbonGroupGenerics(JPanel genericsPanel, CellConstraints cc) {
        JPanel panel = this.createBorderedPanel("No carbon", 1, 3);
        this.createGroupGenerics(panel, cc, 24, 26, 1, 1, 1, 1);
        genericsPanel.add((Component)panel, cc.xy(5, 3));
    }

    private void createGroupGenerics(JPanel genericsPanel, CellConstraints cc, int groupFromIdx, int groupToIdx, int groupsx, int groupsy, int groupsw, int groupsh) {
        int i;
        JPanel groupsPanel = new JPanel();
        int colSpecCount = 3 + (groupToIdx - groupFromIdx) * 2;
        ColumnSpec[] colSpec = new ColumnSpec[colSpecCount];
        colSpec[0] = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        colSpec[1] = FormFactory.LABEL_COMPONENT_GAP_COLSPEC;
        for (i = 0; i < groupToIdx - groupFromIdx; ++i) {
            colSpec[2 + i * 2] = new ColumnSpec("max(default;20dlu)");
            colSpec[3 + i * 2] = FormFactory.LABEL_COMPONENT_GAP_COLSPEC;
        }
        colSpec[colSpecCount - 1] = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        groupsPanel.setLayout((LayoutManager)new FormLayout(colSpec, RowSpec.decodeSpecs((String)"default")));
        for (i = groupFromIdx; i < groupToIdx; ++i) {
            JToggleButton button = this.factory.createGenericsButton(i, this.buttonGroup);
            groupsPanel.add((Component)button, cc.xy(3 + (i - groupFromIdx) * 2, 1));
        }
        genericsPanel.add((Component)groupsPanel, cc.xywh(groupsx, groupsy, groupsw, groupsh));
    }

    private JPanel createBorderedPanel(String title, int columns, int rows) {
        JPanel panel = new JPanel();
        panel.setBorder(new CompoundBorder(new TitledBorder(null, title, 2, 2), new EmptyBorder(2, 2, 2, 2)));
        ColumnSpec[] colSpec = new ColumnSpec[columns];
        for (int i = 0; i < columns; ++i) {
            colSpec[i] = i % 2 == 0 ? FormFactory.DEFAULT_COLSPEC : FormFactory.LABEL_COMPONENT_GAP_COLSPEC;
        }
        RowSpec[] rowSpec = new RowSpec[rows];
        rowSpec[0] = FormFactory.DEFAULT_ROWSPEC;
        rowSpec[1] = FormFactory.UNRELATED_GAP_ROWSPEC;
        for (int i = 2; i < rows - 1; ++i) {
            rowSpec[i] = i % 2 == 0 ? FormFactory.DEFAULT_ROWSPEC : FormFactory.LINE_GAP_ROWSPEC;
        }
        rowSpec[rows - 1] = new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 0.0);
        panel.setLayout((LayoutManager)new FormLayout(colSpec, rowSpec));
        return panel;
    }
}

