/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.MObjectPropertiesPanel;
import chemaxon.marvin.swing.DelegatingAction;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.struc.MObject;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class MObjectPropertiesDialog
implements CallbackIface,
ActionListener {
    private static final String CANCEL_COMMAND = "cancel";
    private static final String OK_COMMAND = "ok";
    private SketchPanel sketchPanel;
    private JDialog dialog = null;
    private MObject[] mObjects;
    private MObjectPropertiesPanel mObjPropsPanel;

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("setSketchPanel")) {
            this.sketchPanel = (SketchPanel)arg;
        } else if (method.equals("setMObjects")) {
            if (arg instanceof MObject) {
                this.mObjects = new MObject[1];
                this.mObjects[0] = (MObject)arg;
            } else {
                this.mObjects = (MObject[])arg;
            }
        } else if (method.equals("show")) {
            this.show();
        }
        return null;
    }

    public void show() {
        this.init();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.sketchPanel);
        this.dialog.setVisible(true);
    }

    private void init() {
        Container parent;
        for (parent = this.sketchPanel; parent != null && !(parent instanceof Window); parent = parent.getParent()) {
        }
        if (parent instanceof Dialog) {
            this.dialog = new JDialog((Dialog)parent);
        } else if (parent instanceof Frame) {
            this.dialog = new JDialog((Frame)parent);
        }
        this.dialog.addWindowListener(new WindowHandler(this.sketchPanel));
        this.dialog.setTitle(MObjectPropertiesPanel.TITLE);
        Container contentPane = this.dialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        contentPane.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        this.mObjPropsPanel = new MObjectPropertiesPanel(this.sketchPanel, this.mObjects, this.dialog);
        gbl.setConstraints(contentPane.add(this.mObjPropsPanel), gbc);
        gbc.anchor = 15;
        gbc.insets.top = 2;
        gbc.insets.bottom = 1;
        gbc.weighty = 0.0;
        ++gbc.gridy;
        gbc.fill = 2;
        gbl.setConstraints(this.addOkCancelPanel(), gbc);
    }

    private JPanel addOkCancelPanel() {
        JPanel panel = new JPanel();
        this.dialog.getContentPane().add(panel);
        panel.add(this.createButton(OK_COMMAND));
        panel.add(this.createButton(CANCEL_COMMAND));
        return panel;
    }

    public JButton createButton(String command) {
        DelegatingAction action = new DelegatingAction(command, MolPanel.GRESOURCES.getString(command));
        action.addActionListener(this);
        return new JButton(action);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (OK_COMMAND.equals(ev.getActionCommand())) {
            this.apply();
        } else if (CANCEL_COMMAND.equals(ev.getActionCommand())) {
            this.cancel();
        }
    }

    private void apply() {
        if (!this.mObjPropsPanel.hasBadValue()) {
            this.dialog.setVisible(false);
            this.mObjPropsPanel.performChanges();
            this.sketchPanel.getEditor().historize();
            this.sketchPanel.repaintMolComponent(0);
        }
    }

    private void cancel() {
        this.dialog.setVisible(false);
    }

    private class WindowHandler
    extends WindowAdapter {
        private final SketchPanel pane;

        public WindowHandler(SketchPanel pane) {
            this.pane = pane;
        }

        @Override
        public void windowClosing(WindowEvent ignored) {
            this.pane.requestFocus();
        }
    }
}

