/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.RgMolecule;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;

public class RlogicDialog
implements CallbackIface,
Serializable,
WindowListener,
ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private SketchPanel sketchPanel;
    private JDialog dialog = null;
    private transient RgMolecule rmol;
    private transient int[] rgids = null;
    private transient JTextField[] rangetxt = null;
    private transient JCheckBox[] restHcb = null;
    private transient JComboBox[] otherCombo = null;
    private int[][] otherGroup = null;

    @Override
    public Object callback(String method, Object o) {
        if (method.equals("setSketchPanel")) {
            this.sketchPanel = (SketchPanel)o;
        } else if (method.equals("show")) {
            this.rmol = o instanceof RgMolecule ? (RgMolecule)o : null;
            this.init1();
        }
        return null;
    }

    private void init0() {
        this.dialog = this.sketchPanel.isParentWindowDialog() ? new JDialog(this.sketchPanel.getParentDialog()) : new JDialog(this.sketchPanel.getParentFrame());
        this.dialog.setTitle("R-logic");
    }

    private void init1() {
        this.init0();
        Container contentPane = this.dialog.getContentPane();
        contentPane.removeAll();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        contentPane.setLayout(gbl);
        FontMetrics fm = this.sketchPanel.getFontMetrics(this.sketchPanel.getFont());
        gbc.gridx = 0;
        gbc.gridy = 0;
        int ipad = fm.stringWidth("aa");
        if (this.rmol == null || this.rmol.getRgroupCount() == 0) {
            JLabel label = new JLabel("No R-groups in this molecule");
            gbl.setConstraints(contentPane.add(label), gbc);
            JButton okay = new JButton("Close");
            okay.setMnemonic('C');
            okay.addActionListener(this);
            okay.setActionCommand("ok");
            gbc.insets.top = ipad;
            gbc.gridy = 1;
            gbl.setConstraints(contentPane.add(okay), gbc);
        } else {
            int i;
            int n = this.rmol.getRgroupCount();
            gbc.ipadx = ipad;
            JLabel[] labels = new JLabel[]{new JLabel("R-group"), new JLabel("Occurence Range"), new JLabel("Rest H"), new JLabel("If .. then ..")};
            for (i = 0; i < labels.length; ++i) {
                gbc.gridx = i;
                gbl.setConstraints(contentPane.add(labels[i]), gbc);
            }
            gbc.ipadx = 0;
            this.rgids = new int[n];
            for (i = 0; i < n; ++i) {
                this.rgids[i] = -1;
            }
            this.rangetxt = new JTextField[n];
            this.restHcb = new JCheckBox[n];
            this.otherCombo = new JComboBox[n];
            this.otherGroup = new int[n][];
            for (i = 0; i < n; ++i) {
                int rlogic = this.rmol.getRlogic(i);
                this.rgids[i] = rlogic & Short.MAX_VALUE;
                int rgroup2 = -1;
                if ((rlogic & 0x8000) != 0) {
                    rgroup2 = rlogic >> 16 & Short.MAX_VALUE;
                }
                boolean restH = (rlogic & Integer.MIN_VALUE) != 0;
                ++gbc.gridy;
                gbc.gridx = 0;
                JLabel label = new JLabel("R" + this.rgids[i]);
                gbl.setConstraints(contentPane.add(label), gbc);
                this.rangetxt[i] = new JTextField(this.rmol.getRlogicRange(i));
                this.rangetxt[i].addActionListener(this);
                this.rangetxt[i].setActionCommand("ok");
                this.rangetxt[i].addFocusListener(this);
                gbc.fill = 1;
                gbc.gridx = 1;
                gbl.setConstraints(contentPane.add(this.rangetxt[i]), gbc);
                this.restHcb[i] = new JCheckBox("", restH);
                gbc.fill = 0;
                gbc.gridx = 2;
                gbl.setConstraints(contentPane.add(this.restHcb[i]), gbc);
                String[] otherList = new String[n];
                otherList[0] = "none";
                this.otherGroup[i] = new int[n - 1];
                int pos = 1;
                int index = 0;
                for (int j = 0; j < n; ++j) {
                    if (this.rgids[j] == this.rgids[i]) continue;
                    int other = this.rmol.getRgroupId(j);
                    otherList[pos] = "If R" + this.rgids[i] + " then R" + other;
                    this.otherGroup[i][pos - 1] = other;
                    if (other == rgroup2) {
                        index = pos;
                    }
                    ++pos;
                }
                this.otherCombo[i] = new JComboBox<String>(otherList);
                this.otherCombo[i].setSelectedIndex(index);
                gbc.gridx = 3;
                gbl.setConstraints(contentPane.add(this.otherCombo[i]), gbc);
            }
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = labels.length;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            JPanel panel = new JPanel();
            gbl.setConstraints(contentPane.add(panel), gbc);
            JButton okay = new JButton("OK");
            panel.add(okay);
            okay.setMnemonic('O');
            okay.addActionListener(this);
            okay.setActionCommand("ok");
            JButton cancel = new JButton("Cancel");
            panel.add(cancel);
            cancel.setMnemonic('C');
            cancel.addActionListener(this);
            cancel.setActionCommand("cancel");
        }
        this.dialog.addWindowListener(this);
        this.dialog.pack();
        try {
            Method m = JDialog.class.getMethod("setLocationRelativeTo", Component.class);
            m.invoke((Object)this.dialog, this.sketchPanel);
        }
        catch (Exception ex) {
            // empty catch block
        }
        Timer t = new Timer(20, this);
        t.setRepeats(false);
        t.start();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public synchronized void windowClosing(WindowEvent e) {
        this.sketchPanel.closeRlogicDialog(this.dialog);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String cmd = ev.getActionCommand();
        if (ev.getSource() instanceof Timer) {
            this.sketchPanel.showWindow(this.dialog);
        } else if (cmd.equals("cancel")) {
            this.windowClosing(null);
        } else if (cmd.equals("ok")) {
            boolean error = false;
            if (this.rgids != null) {
                boolean changed = false;
                for (int i = 0; i < this.rgids.length; ++i) {
                    boolean restH = this.restHcb[i].isSelected();
                    int otherIndex = this.otherCombo[i].getSelectedIndex();
                    int other = otherIndex > 0 ? this.otherGroup[i][otherIndex - 1] : -1;
                    int index = this.rmol.findRgroupIndex(this.rgids[i]);
                    if (index < 0) continue;
                    int f = this.rgids[i];
                    if (other >= 0) {
                        f |= 0x8000 | other << 16;
                    }
                    if (restH) {
                        f |= Integer.MIN_VALUE;
                    }
                    if (this.rmol.getRlogic(i) != f) {
                        this.rmol.setRlogic(i, f);
                        changed = true;
                    }
                    try {
                        this.normalizeOccurenceRange(i);
                        changed = this.setOccurenceRange(i);
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        this.showIllegalOccurenceRangeDialog(ex);
                        error = true;
                    }
                }
                if (changed) {
                    MolEditor medit = this.sketchPanel.getEditor();
                    medit.setMol(this.rmol);
                }
            }
            if (!error) {
                this.windowClosing(null);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent ev) {
    }

    @Override
    public void focusLost(FocusEvent ev) {
        Object src = ev.getSource();
        for (int i = 0; i < this.rangetxt.length; ++i) {
            if (src != this.rangetxt[i]) continue;
            try {
                this.normalizeOccurenceRange(i);
            }
            catch (IllegalArgumentException ex) {
                this.showIllegalOccurenceRangeDialog(ex);
            }
            break;
        }
    }

    private void normalizeOccurenceRange(int i) throws IllegalArgumentException {
        String range = this.rangetxt[i].getText().trim();
        StringTokenizer st = new StringTokenizer(range, " \t\n\r");
        if (st.hasMoreTokens()) {
            StringBuffer sb = new StringBuffer(st.nextToken());
            while (st.hasMoreTokens()) {
                char c1 = sb.charAt(sb.length() - 1);
                String s = st.nextToken();
                char c2 = s.charAt(0);
                if (Character.isLetterOrDigit(c1) && Character.isLetterOrDigit(c2)) {
                    sb.append(' ');
                }
                sb.append(s);
            }
            range = sb.toString();
            if (range.charAt(0) == '=') {
                try {
                    Integer.parseInt(range.substring(1));
                    range = range.substring(1);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            range = this.rmol.checkRlogicRange(i, range);
            this.rangetxt[i].setText(range);
        }
    }

    private boolean setOccurenceRange(int i) throws IllegalArgumentException {
        String range = this.rangetxt[i].getText().trim();
        if (!this.rmol.getRlogicRange(i).equals(range)) {
            this.rmol.setRlogicRange(i, range);
            return true;
        }
        return false;
    }

    private void showIllegalOccurenceRangeDialog(IllegalArgumentException ex) {
        JOptionPane.showMessageDialog(this.dialog, ex.getMessage(), "Illegal occurence range", 0);
    }
}

