/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.AddTemplateSetDialogImpl;
import chemaxon.marvin.sketch.swing.modules.FlowScrollLayout;
import chemaxon.marvin.sketch.swing.modules.TemplateLibraryManagerDropTarget;
import chemaxon.marvin.sketch.swing.modules.TemplateOptionsDialogImpl;
import chemaxon.marvin.sketch.swing.templates.TemplateAction;
import chemaxon.marvin.sketch.swing.templates.TemplateDisplayOption;
import chemaxon.marvin.sketch.swing.templates.TemplateIconFactory;
import chemaxon.marvin.sketch.swing.templates.TemplateLibraryManager;
import chemaxon.marvin.sketch.swing.templates.TemplatePresentationModel;
import chemaxon.marvin.sketch.templates.TemplateSet;
import chemaxon.marvin.uif.util.swing.AbstractDialog;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class TemplateLibraryManagerDialogImpl
extends AbstractDialog
implements PropertyChangeListener,
TemplateLibraryManager {
    private static final long serialVersionUID = 1L;
    private static final String TITLE_KEY = "TemplateLibaryManagerDialog.title";
    private static final String TEMPLATES_TAB_TITLE = "Templates.tabTitle";
    private static final String PROPERTIES_TAB_TITLE = "Properties.tabTitle";
    private SketchPanel sketchPanel;
    private JSplitPane splitPane;
    private TemplateDisplayOption displayOptions;
    private JTree templateTree;
    ResourceBundle RESOURCES;
    private JComponent selectedTemplate = null;
    private Color selectedTemplateBackground = new Color(221, 221, 221);

    public TemplateLibraryManagerDialogImpl(Frame frame, SketchPanel sketchPanel) {
        super((Window)frame, "", false);
        this.init(sketchPanel);
    }

    public TemplateLibraryManagerDialogImpl(Dialog dialog, SketchPanel sketchPanel) {
        super((Window)dialog, "", false);
        this.init(sketchPanel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("templateActions".equals(evt.getPropertyName())) {
            this.createTabbedTemplatePanel();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TemplateLibraryManagerDialogImpl.this.splitPane.revalidate();
                    TemplateLibraryManagerDialogImpl.this.splitPane.repaint();
                }
            });
        } else if ("templateStructure".equals(evt.getPropertyName())) {
            ArrayList<Integer> rows = this.getRowIndexes(this.templateTree.getSelectionPath());
            this.templateTree.setModel(this.sketchPanel.getTemplatePresentationModel().getTemplateSetTreeModel());
            for (int row = rows.size() - 1; row >= 0; --row) {
                this.templateTree.expandRow(rows.get(row));
            }
            if (rows.size() > 0) {
                this.templateTree.setSelectionPath(this.templateTree.getPathForRow(rows.get(0)));
            }
        } else if ("treeSelectionStarted".equals(evt.getPropertyName())) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else if ("treeSelectionFinished".equals(evt.getPropertyName())) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private ArrayList<Integer> getRowIndexes(TreePath path) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        while (path != null) {
            rows.add(this.templateTree.getRowForPath(path));
            path = path.getParentPath();
        }
        return rows;
    }

    private void createTabbedTemplatePanel() {
        TemplatePresentationModel model = this.sketchPanel.getTemplatePresentationModel();
        JComponent templatePanel = this.createTemplatePanel(model.getSelectedTemplateActions());
        new TemplateLibraryManagerDropTarget(this, this.sketchPanel.getTemplateHandler());
        JTabbedPane tabbedPane1 = new JTabbedPane();
        tabbedPane1.setTabPlacement(3);
        tabbedPane1.addTab(this.RESOURCES.getString(TEMPLATES_TAB_TITLE), templatePanel);
        tabbedPane1.addTab(this.RESOURCES.getString(PROPERTIES_TAB_TITLE), this.createPropertiesPanel(model.getSelectedTemplateSet()));
        int oldLoc = this.splitPane.getDividerLocation();
        Component c = this.splitPane.getRightComponent();
        if (c instanceof JTabbedPane) {
            tabbedPane1.setSelectedIndex(((JTabbedPane)c).getSelectedIndex());
        }
        this.splitPane.setRightComponent(tabbedPane1);
        if (oldLoc != -1) {
            this.splitPane.setDividerLocation(oldLoc);
        }
    }

    private JComponent createTemplatePanel(List<TemplateAction> templates) {
        JPanel templatePanel = new JPanel();
        templatePanel.setBackground(Color.white);
        templatePanel.setOpaque(true);
        templatePanel.setBorder(Borders.TABBED_DIALOG_BORDER);
        JScrollPane scrollPane = new JScrollPane(templatePanel);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        if (templates != null) {
            templatePanel.setLayout(new FlowScrollLayout(scrollPane));
            int i = 1;
            for (final TemplateAction action : templates) {
                JPanel panel = new JPanel();
                panel.setBackground(Color.white);
                panel.setOpaque(true);
                panel.setLayout(new BorderLayout());
                Icon molIcon = new Icon(){
                    Icon image = null;

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        if (this.image == null) {
                            this.image = TemplateIconFactory.getInstance().getIcon(action.getTemplate(), TemplateLibraryManagerDialogImpl.this.displayOptions);
                        }
                        this.image.paintIcon(c, g, x, y);
                    }

                    @Override
                    public int getIconWidth() {
                        return TemplateLibraryManagerDialogImpl.this.displayOptions.getSize();
                    }

                    @Override
                    public int getIconHeight() {
                        return TemplateLibraryManagerDialogImpl.this.displayOptions.getSize();
                    }
                };
                JLabel label = new JLabel();
                label.setBorder(new LineBorder(Color.lightGray));
                label.setIcon(molIcon);
                panel.add((Component)label, "Center");
                String name = action.getValue("ShortDescription").toString();
                label.setToolTipText(name);
                JLabel nameLabel = new JLabel();
                nameLabel.setText(i + ": " + name);
                nameLabel.setToolTipText(name);
                nameLabel.setHorizontalAlignment(0);
                nameLabel.setPreferredSize(new Dimension(this.displayOptions.getSize(), nameLabel.getPreferredSize().height));
                panel.add((Component)nameLabel, "South");
                this.addMouseListener(label, action);
                if (action.getTemplate().isEditable()) {
                    this.sketchPanel.getTemplatePresentationModel().addPopupMenu(label, action);
                }
                templatePanel.add(panel);
                ++i;
            }
        }
        return scrollPane;
    }

    private JComponent createPropertiesPanel(final TemplateSet selectedTemplateSet) {
        String name = selectedTemplateSet == null ? "" : selectedTemplateSet.getName();
        String location = selectedTemplateSet == null ? "" : selectedTemplateSet.getLocation();
        JPanel propertiesPanel = new JPanel();
        propertiesPanel.setBorder(Borders.TABBED_DIALOG_BORDER);
        propertiesPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(default;80px)")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        CellConstraints cc = new CellConstraints();
        JLabel title1 = compFactory.createTitle(this.RESOURCES.getString("Properties.TemplateSet") + ":");
        JLabel label7 = compFactory.createLabel(this.RESOURCES.getString("Properties.Name") + ":");
        JLabel label1 = compFactory.createLabel(this.RESOURCES.getString("Properties.Location") + ":");
        JTextField textField1 = new JTextField();
        JTextField textField2 = new JTextField();
        JLabel title3 = compFactory.createTitle(this.RESOURCES.getString("Properties.Settings") + ":");
        JCheckBox checkBox1 = new JCheckBox();
        JCheckBox checkBox2 = new JCheckBox();
        propertiesPanel.add((Component)title1, cc.xy(1, 1));
        propertiesPanel.add((Component)label7, cc.xy(1, 3));
        textField2.setText(name);
        textField2.setEditable(false);
        propertiesPanel.add((Component)textField2, cc.xywh(3, 3, 3, 1));
        propertiesPanel.add((Component)label1, cc.xy(1, 5));
        textField1.setText(location);
        textField1.setEditable(false);
        propertiesPanel.add((Component)textField1, cc.xywh(3, 5, 3, 1));
        propertiesPanel.add((Component)title3, cc.xy(1, 7));
        checkBox1.setText(this.RESOURCES.getString("Properties.DisplayOnToolBar"));
        checkBox1.setSelected(this.sketchPanel.getTemplateHandler().isTemplateSetVisibleOnToolbar(selectedTemplateSet));
        boolean enabled = this.sketchPanel.getTemplateHandler().isToolBarCustomizationEnabled() && selectedTemplateSet != null && selectedTemplateSet.isContainsTemplates();
        checkBox1.setEnabled(enabled);
        checkBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                TemplateLibraryManagerDialogImpl.this.sketchPanel.getTemplateHandler().setTemplateSetVisibleOnToolbar(selectedTemplateSet, selected, true);
                TemplateLibraryManagerDialogImpl.this.templateTree.repaint();
            }
        });
        propertiesPanel.add((Component)checkBox1, cc.xywh(3, 7, 3, 1));
        checkBox2.setText(this.RESOURCES.getString("Properties.Clean2DTemplate"));
        checkBox2.setSelected(this.sketchPanel.getTemplateHandler().isClean2DTemplates(selectedTemplateSet));
        checkBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                TemplateLibraryManagerDialogImpl.this.sketchPanel.getTemplateHandler().setClean2DTemplates(selectedTemplateSet, selected);
                TemplateLibraryManagerDialogImpl.this.templateTree.repaint();
            }
        });
        propertiesPanel.add((Component)checkBox2, cc.xywh(3, 9, 3, 1));
        JButton reloadButton = new JButton(this.RESOURCES.getString("Properties.Reload"));
        reloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplateLibraryManagerDialogImpl.this.sketchPanel.getTemplateHandler().reloadTemplateSet(selectedTemplateSet);
            }
        });
        propertiesPanel.add((Component)reloadButton, cc.xy(5, 11));
        return propertiesPanel;
    }

    private void addMouseListener(final JComponent component, final TemplateAction action) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                component.setBorder(new LineBorder(Color.black));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                component.setBorder(new LineBorder(Color.lightGray));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    if (TemplateLibraryManagerDialogImpl.this.selectedTemplate != null) {
                        TemplateLibraryManagerDialogImpl.this.selectedTemplate.setOpaque(false);
                        TemplateLibraryManagerDialogImpl.this.selectedTemplate.setBackground(null);
                    }
                    TemplateLibraryManagerDialogImpl.this.selectedTemplate = component;
                    TemplateLibraryManagerDialogImpl.this.selectedTemplate.setOpaque(true);
                    TemplateLibraryManagerDialogImpl.this.selectedTemplate.setBackground(TemplateLibraryManagerDialogImpl.this.selectedTemplateBackground);
                    action.actionPerformed(TemplateLibraryManagerDialogImpl.this.sketchPanel);
                    TemplateLibraryManagerDialogImpl.this.sketchPanel.requestFocus();
                }
            }
        });
    }

    private void init(SketchPanel panel) {
        this.sketchPanel = panel;
        this.displayOptions = new TemplateDisplayOption(100);
        this.displayOptions.setDisplayMode(1);
        this.displayOptions.setBackground(Color.white);
        this.displayOptions.setSimpleMoleculeScale(28.0);
        this.RESOURCES = MolPanel.getResourceBundle(TemplateLibraryManagerDialogImpl.class.getName());
        this.setTitle(this.RESOURCES.getString(TITLE_KEY));
        this.setResizable(true);
    }

    private JToolBar createToolBar(TemplatePresentationModel templateModel) {
        return new TemplateLibraryManagerToolbar(templateModel);
    }

    @Override
    protected JComponent buildContentPanel() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        TemplatePresentationModel templateModel = this.sketchPanel.getTemplatePresentationModel();
        templateModel.addListener(this);
        this.templateTree = new JTree(templateModel.getTemplateSetTreeModel());
        this.templateTree.setSelectionModel(templateModel.getTemplateTreeSelectionModel());
        this.templateTree.setShowsRootHandles(true);
        this.templateTree.setToggleClickCount(2);
        this.templateTree.setCellRenderer(new CustomTreeRenderer());
        scrollPane.setViewportView(this.templateTree);
        scrollPane.setMinimumSize(new Dimension(150, 150));
        this.splitPane = new JSplitPane();
        this.splitPane.setLeftComponent(scrollPane);
        this.splitPane.setPreferredSize(new Dimension(650, 300));
        this.createTabbedTemplatePanel();
        contentPanel.add((Component)this.splitPane, "Center");
        contentPanel.add((Component)this.createToolBar(templateModel), "North");
        return contentPanel;
    }

    @Override
    protected JComponent buildButtonBar() {
        return this.buildCloseButtonBar();
    }

    @Override
    public void setTemplateLabelSize(int templateLabelSize) {
        this.displayOptions.setSize(templateLabelSize);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TemplateLibraryManagerDialogImpl.this.createTabbedTemplatePanel();
            }
        });
    }

    private class CustomTreeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        Icon customToolBarIcon = this.createCustomIcon(true, false);
        Icon customClean2DIcon = this.createCustomIcon(false, true);
        Icon customToolBarClean2DIcon = this.createCustomIcon(true, true);

        private Icon createCustomIcon(boolean paintToolBar, boolean paintClean2D) {
            Icon icon = this.getLeafIcon();
            BufferedImage result = new BufferedImage(16, 16, 6);
            Graphics2D g = result.createGraphics();
            icon.paintIcon(this, g, 0, 0);
            if (paintToolBar) {
                this.paintToolBarBadget(g);
            }
            if (paintClean2D) {
                this.paintClean2DBadget(g);
            }
            return new ImageIcon(result);
        }

        private void paintToolBarBadget(Graphics2D g) {
            g.setColor(Color.white);
            g.setStroke(new BasicStroke(3.0f));
            g.drawLine(3, 13, 3, 8);
            g.drawLine(0, 8, 5, 8);
            g.setColor(Color.blue);
            g.setStroke(new BasicStroke(1.0f));
            g.drawLine(3, 13, 3, 8);
            g.drawLine(0, 8, 5, 8);
        }

        private void paintClean2DBadget(Graphics2D g) {
            g.setColor(new Color(8, 118, 147));
            int basey = 7;
            g.fillRect(8, basey, 7, 7);
            g.setColor(Color.white);
            g.drawLine(9, basey + 4, 13, basey + 4);
            g.drawLine(10, basey + 3, 12, basey + 3);
            g.drawLine(11, basey + 2, 11, basey + 2);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasfocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasfocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (leaf && node.getUserObject() instanceof TemplateSet) {
                TemplateSet set = (TemplateSet)node.getUserObject();
                boolean toolbar = TemplateLibraryManagerDialogImpl.this.sketchPanel.getTemplateHandler().isTemplateSetVisibleOnToolbar(set);
                boolean clean = TemplateLibraryManagerDialogImpl.this.sketchPanel.getTemplateHandler().isClean2DTemplates(set);
                if (toolbar && clean) {
                    this.setIcon(this.customToolBarClean2DIcon);
                } else if (toolbar) {
                    this.setIcon(this.customToolBarIcon);
                } else if (clean) {
                    this.setIcon(this.customClean2DIcon);
                }
            }
            return this;
        }
    }

    class TemplateLibraryManagerToolbar
    extends JToolBar {
        private static final long serialVersionUID = 1L;

        TemplateLibraryManagerToolbar(TemplatePresentationModel templateModel) {
            this.setRollover(true);
            JButton addLibraryButton = this.createAddLibraryButton();
            this.add(addLibraryButton);
            final JButton removeLibraryButton = this.createRemoveLibraryButton();
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String property = propertyChangeEvent.getPropertyName();
                    if ("removeTemplateSetEnabled".equals(property)) {
                        removeLibraryButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                    }
                }
            };
            templateModel.addListener(propertyChangeListener);
            this.add(removeLibraryButton);
            this.addSeparator();
            this.add(this.createMoveLibraryUpButton());
            this.add(this.createMoveLibraryDownButton());
            this.addSeparator();
            JButton optionsButton = this.createTemplateOptionsButton();
            this.add(optionsButton);
        }

        private JButton createTemplateOptionsButton() {
            JButton optionsButton = new JButton();
            optionsButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/options24.png")));
            optionsButton.setToolTipText(TemplateLibraryManagerDialogImpl.this.RESOURCES.getString("Options"));
            optionsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TemplateOptionsDialogImpl dialog = new TemplateOptionsDialogImpl((Dialog)TemplateLibraryManagerDialogImpl.this, TemplateLibraryManagerDialogImpl.this.sketchPanel);
                    dialog.open();
                }
            });
            return optionsButton;
        }

        private JButton createAddLibraryButton() {
            JButton addLibraryButton = new JButton();
            addLibraryButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/add_templates24.png")));
            addLibraryButton.setToolTipText(TemplateLibraryManagerDialogImpl.this.RESOURCES.getString("AddLibrary"));
            addLibraryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddTemplateSetDialogImpl content = new AddTemplateSetDialogImpl((Dialog)TemplateLibraryManagerDialogImpl.this, TemplateLibraryManagerDialogImpl.this.sketchPanel);
                    content.open();
                }
            });
            return addLibraryButton;
        }

        private JButton createRemoveLibraryButton() {
            JButton removeLibraryButton = new JButton();
            removeLibraryButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/remove_templates24.png")));
            removeLibraryButton.setToolTipText(TemplateLibraryManagerDialogImpl.this.RESOURCES.getString("RemoveLibrary"));
            removeLibraryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)TemplateLibraryManagerDialogImpl.this.templateTree.getSelectionPath().getLastPathComponent();
                    Object o = node.getUserObject();
                    if (o instanceof TemplateSet) {
                        String name = ((TemplateSet)o).getName();
                        int answer = JOptionPane.showConfirmDialog(TemplateLibraryManagerDialogImpl.this, "Remove the Template Set '" + name + "' from the Library?\n" + "No files will be deleted on disk.", "Remove Template Set", 2);
                        if (answer == 0) {
                            TemplateLibraryManagerDialogImpl.this.sketchPanel.getTemplateHandler().removeTemplateSet((TemplateSet)o);
                        }
                    }
                }
            });
            return removeLibraryButton;
        }

        private JButton createMoveLibraryUpButton() {
            JButton moveLibraryUpButton = new JButton();
            moveLibraryUpButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/pages/up24.png")));
            moveLibraryUpButton.setToolTipText(TemplateLibraryManagerDialogImpl.this.RESOURCES.getString("MoveLibraryUp"));
            moveLibraryUpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int r;
                    if (TemplateLibraryManagerDialogImpl.this.sketchPanel.getTemplateHandler().moveTemplateSetUp(TemplateLibraryManagerDialogImpl.this.sketchPanel.getTemplatePresentationModel().getSelectedTemplateSet()) && (r = TemplateLibraryManagerDialogImpl.this.templateTree.getRowForPath(TemplateLibraryManagerDialogImpl.this.templateTree.getSelectionPath())) > 0) {
                        TemplateLibraryManagerDialogImpl.this.templateTree.setSelectionPath(TemplateLibraryManagerDialogImpl.this.templateTree.getPathForRow(r - 1));
                    }
                }
            });
            return moveLibraryUpButton;
        }

        private JButton createMoveLibraryDownButton() {
            JButton moveLibraryDownButton = new JButton();
            moveLibraryDownButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/pages/down24.png")));
            moveLibraryDownButton.setToolTipText(TemplateLibraryManagerDialogImpl.this.RESOURCES.getString("MoveLibraryDown"));
            moveLibraryDownButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int r;
                    if (TemplateLibraryManagerDialogImpl.this.sketchPanel.getTemplateHandler().moveTemplateSetDown(TemplateLibraryManagerDialogImpl.this.sketchPanel.getTemplatePresentationModel().getSelectedTemplateSet()) && (r = TemplateLibraryManagerDialogImpl.this.templateTree.getRowForPath(TemplateLibraryManagerDialogImpl.this.templateTree.getSelectionPath())) < TemplateLibraryManagerDialogImpl.this.templateTree.getRowCount() - 1) {
                        TemplateLibraryManagerDialogImpl.this.templateTree.setSelectionPath(TemplateLibraryManagerDialogImpl.this.templateTree.getPathForRow(r + 1));
                    }
                }
            });
            return moveLibraryDownButton;
        }
    }
}

