/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import chemaxon.marvin.sketch.swing.modules.TemplateLibraryManagerDialogImpl;
import chemaxon.marvin.sketch.swing.templates.TemplateHandler;
import chemaxon.struc.Molecule;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;

public class TemplateLibraryManagerDropTarget
extends DropTargetAdapter {
    private TemplateLibraryManagerDialogImpl libraryManager;
    private TemplateHandler templateHandler;

    public TemplateLibraryManagerDropTarget(TemplateLibraryManagerDialogImpl libraryManager, TemplateHandler templateHandler) {
        this.libraryManager = libraryManager;
        this.templateHandler = templateHandler;
        libraryManager.setDropTarget(new DropTarget(libraryManager, this));
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (this.templateHandler != null && (dtde.getDropAction() & 3) != 0) {
            dtde.acceptDrop(dtde.getDropAction());
            Transferable t = dtde.getTransferable();
            Molecule dropMol = (Molecule)ClipboardHandler.getObjectFromTransferable(t);
            if (dropMol != null) {
                this.templateHandler.addToMyTemplates(dropMol);
                dtde.dropComplete(true);
            } else {
                dtde.dropComplete(false);
            }
        } else {
            dtde.rejectDrop();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.handleDragEvent(dtde);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        this.handleDragEvent(dtde);
    }

    private void handleDragEvent(DropTargetDragEvent dtde) {
        if (this.isValidLocation(dtde.getLocation())) {
            dtde.acceptDrag(3);
        } else {
            dtde.rejectDrag();
        }
    }

    private boolean isValidLocation(Point location) {
        return this.templateHandler != null && this.libraryManager.isVisible() && this.libraryManager.contains(location);
    }
}

