/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.templates.TemplateAction;
import chemaxon.marvin.uif.util.swing.AbstractDialog;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TemplatePropertiesDialogImpl
extends AbstractDialog {
    private static final String TITLE = "Template Properties";
    private TemplateAction templateAction;
    private JTextField name;
    private JTextField leftAbbreviation;
    private SketchPanel sketchPanel;

    public TemplatePropertiesDialogImpl(Frame frame, SketchPanel sketchPanel, TemplateAction action) {
        super((Window)frame, TITLE, true);
        this.sketchPanel = sketchPanel;
        this.templateAction = action;
    }

    public TemplatePropertiesDialogImpl(Dialog dialog, SketchPanel sketchPanel, TemplateAction action) {
        super((Window)dialog, TITLE, true);
        this.sketchPanel = sketchPanel;
        this.templateAction = action;
    }

    @Override
    protected JComponent buildButtonBar() {
        return this.buildOKCancelButtonBar();
    }

    @Override
    protected JComponent buildContentPanel() {
        JPanel panel = new JPanel();
        CellConstraints cc = new CellConstraints();
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel nameL = new JLabel("Name:");
        panel.add((Component)nameL, cc.xy(1, 1));
        this.name = new JTextField();
        this.name.setText(this.templateAction.getTemplate().getLongName());
        panel.add((Component)this.name, cc.xy(3, 1));
        JLabel abbrevL = new JLabel("Abbreviation:");
        panel.add((Component)abbrevL, cc.xy(1, 3));
        this.leftAbbreviation = new JTextField();
        this.leftAbbreviation.setText(this.templateAction.getTemplate().getLeftAbbreviation());
        panel.add((Component)this.leftAbbreviation, cc.xy(3, 3));
        return panel;
    }

    @Override
    protected Action getOKAction() {
        return new OKAction();
    }

    private class OKAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public OKAction() {
            super("OK");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TemplatePropertiesDialogImpl.this.templateAction.setName(TemplatePropertiesDialogImpl.this.name.getText());
            TemplatePropertiesDialogImpl.this.templateAction.getTemplate().setLeftAbbreviation(TemplatePropertiesDialogImpl.this.leftAbbreviation.getText());
            TemplatePropertiesDialogImpl.this.sketchPanel.getTemplateHandler().resetMyTemplates();
            TemplatePropertiesDialogImpl.this.doOk();
        }
    }
}

