/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.atompropertyeditor;

import chemaxon.enumeration.homology.HomologyPropertyTypes;
import chemaxon.marvin.sketch.swing.atompropertyeditor.PresentationChooser;
import chemaxon.marvin.sketch.swing.modules.atompropertyeditor.editors.AbstractTextBasedAtomPropertyEditor;
import chemaxon.marvin.sketch.swing.modules.atompropertyeditor.editors.HomologyBranchingAtomPropertyEditor;
import chemaxon.marvin.sketch.swing.modules.atompropertyeditor.editors.HomologyRingTypeAtomPropertyEditor;
import chemaxon.marvin.sketch.swing.modules.atompropertyeditor.editors.HomologySaturationAtomPropertyEditor;
import chemaxon.marvin.sketch.swing.modules.atompropertyeditor.editors.HomologySizeAtomPropertyEditor;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class PresentationChooserImpl
implements PresentationChooser {
    protected static final TableCellEditor defaultEditor = new DefaultCellEditor(new JTextField());
    protected static final TableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
    protected final Map<String, TableCellRenderer> rendererCache = new HashMap<String, TableCellRenderer>();
    protected final Map<String, TableCellEditor> editorCache = new HashMap<String, TableCellEditor>();
    protected final Properties itemProperties = new Properties();
    protected final TableCellRenderer propertyKeyRenderer = new DefaultTableCellRenderer(){
        private static final long serialVersionUID = 7670688331831470559L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null && Boolean.parseBoolean(PresentationChooserImpl.this.itemProperties.getProperty(value.toString() + ".reserved", "false"))) {
                label.setEnabled(true);
                label.setText("<html><b>" + PresentationChooserImpl.this.itemProperties.getProperty(value.toString() + ".name", value.toString()) + "</b></html>");
                label.setToolTipText(PresentationChooserImpl.this.itemProperties.getProperty(value.toString() + ".help"));
            } else if (row + 1 == table.getRowCount() && value == null) {
                label.setText("<Type new property name here>");
                label.setToolTipText("Add new property");
                label.setEnabled(false);
            } else {
                label.setEnabled(true);
                label.setToolTipText(label.getText());
            }
            return label;
        }
    };
    protected final TableCellEditor propertyKeyEditor = new DefaultCellEditor(new JTextField()){
        private static final long serialVersionUID = -4304165453900672710L;

        @Override
        public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, final int row, int column) {
            if (value != null && Boolean.parseBoolean(PresentationChooserImpl.this.itemProperties.getProperty(value.toString() + ".reserved", "false"))) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        table.editCellAt(row, 1);
                    }
                });
                return null;
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    };

    public PresentationChooserImpl() {
        this(true);
    }

    protected PresentationChooserImpl(boolean useDefaultEditorsAndRenderers) {
        if (useDefaultEditorsAndRenderers) {
            this.editorCache.put("BRANCHING", new HomologyBranchingAtomPropertyEditor());
            this.editorCache.put("RINGTYPE", new HomologyRingTypeAtomPropertyEditor());
            this.editorCache.put("SATURATION", new HomologySaturationAtomPropertyEditor());
            this.editorCache.put("SIZE", new HomologySizeAtomPropertyEditor());
            this.editorCache.put("DTCOUNT", new AbstractTextBasedAtomPropertyEditor(){

                @Override
                protected boolean isValid(String value) {
                    return HomologyPropertyTypes.DeuteriumTritium.isValidPropertyString(value == null ? "" : value);
                }
            });
            this.editorCache.put("TEXTNOTES", new AbstractTextBasedAtomPropertyEditor(){

                @Override
                protected boolean isValid(String value) {
                    return HomologyPropertyTypes.Textnotes.isValidPropertyString(value == null ? "" : value);
                }
            });
            this.rendererCache.put("BRANCHING", new HomologyBranchingAtomPropertyEditor());
            this.rendererCache.put("RINGTYPE", new HomologyRingTypeAtomPropertyEditor());
            this.rendererCache.put("SATURATION", new HomologySaturationAtomPropertyEditor());
            this.rendererCache.put("SIZE", new HomologySizeAtomPropertyEditor());
            this.rendererCache.put("DTCOUNT", new AbstractTextBasedAtomPropertyEditor(){

                @Override
                protected boolean isValid(String value) {
                    return HomologyPropertyTypes.DeuteriumTritium.isValidPropertyString(value == null ? "" : value);
                }
            });
            this.rendererCache.put("TEXTNOTES", new AbstractTextBasedAtomPropertyEditor(){

                @Override
                protected boolean isValid(String value) {
                    return HomologyPropertyTypes.Textnotes.isValidPropertyString(value == null ? "" : value);
                }
            });
            String[] propNames = HomologyPropertyTypes.getAllReservedPropertyNames();
            for (int i = 0; i < propNames.length; ++i) {
                this.itemProperties.setProperty(propNames[i] + ".reserved", "true");
            }
            this.itemProperties.setProperty("BRANCHING.name", "Branching");
            this.itemProperties.setProperty("RINGTYPE.name", "Ring Type");
            this.itemProperties.setProperty("SATURATION.name", "Saturation");
            this.itemProperties.setProperty("SIZE.name", "Size");
            this.itemProperties.setProperty("DTCOUNT.name", "Deuterium or Tritium Count");
            this.itemProperties.setProperty("TEXTNOTES.name", "Additional Text Notes");
            this.itemProperties.setProperty("BRANCHING.help", "<html><body>Branching property<BR>Values:<br>&nbsp branched <br>&nbsp straight</body></html>");
            this.itemProperties.setProperty("RINGTYPE.help", "<html><body>Ring Type property <br>Values:<br>&nbsp multicyclic <br>&nbsp monocyclic</body></html>");
            this.itemProperties.setProperty("SATURATION.help", "<html><body>Saturation property<BR>Values:<br>&nbsp saturated <br>&nbsp unsaturated</body></html>");
            this.itemProperties.setProperty("SIZE.help", "<html><body>Size property<BR>Specifies the number of carbon atoms.<br>Values: low (1-6), mid (7-10), high (11-)<br>Multiple selections are possible</body></html>");
            this.itemProperties.setProperty("DTCOUNT.help", "<html><body>Deuterium or Tritium Count property<br>Text format:D&lt;number range&gt and/or T&lt;number range&gt<br>e.g. D1-4T3</body></html>");
            this.itemProperties.setProperty("TEXTNOTES.help", "<html><body>Additional Text Notes property<br>Text format: Letters denoting different parameters followed by number ranges. <br> These entries are separated by commas (,). Specification of attachment atom type is also possible.<br>Possible parameters: <dl><dt>E</dt><dd>Number of double bonds</dd><dt>Y</dt><dd>Number of triple bonds</dd><dt>C</dt><dd>Number of carbon atoms</dd><dt>Hetero atom symbol</dt><dd>Number of occurrences of a particular heteroatom</dd><dt>X</dt><dd>Number of occurrences of heteroatoms  not defined otherwise</dd><dt>NR</dt><dd>Number of rings in a ring system</dd><dt>RA</dt><dd>Number of atoms in a ring system</dd><dt>&gt;atomic symbol</dt><dd>Presence of one attachment to the specified atom</dd><dt>&gt&gt;atomic symbol</dt><dd>Presence of more than one attachment <br>to the specified atom</dd></dl> e.g N1-3,NR4,E1-2,&gt&gt;C</body></html>");
        }
    }

    @Override
    public TableCellEditor getPropertyKeyEditor(String propertyName) {
        return this.propertyKeyEditor;
    }

    @Override
    public TableCellRenderer getPropertyKeyRenderer(String propertyName) {
        return this.propertyKeyRenderer;
    }

    @Override
    public TableCellEditor getPropertyValueEditor(String propertyName) {
        if (this.editorCache.containsKey(propertyName)) {
            return this.editorCache.get(propertyName);
        }
        return defaultEditor;
    }

    @Override
    public TableCellRenderer getPropertyValueRenderer(String propertyName) {
        if (this.rendererCache.containsKey(propertyName)) {
            return this.rendererCache.get(propertyName);
        }
        return defaultRenderer;
    }
}

