/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.atompropertyeditor.editors;

import chemaxon.marvin.sketch.swing.modules.atompropertyeditor.editors.AbstractAtomPropertyEditor;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class HomologySizeAtomPropertyEditor
extends AbstractAtomPropertyEditor {
    private static final long serialVersionUID = -4505689292807208645L;
    private static final String LOW = "LO";
    private static final String MIDDLE = "MID";
    private static final String HIGH = "HI";
    private JCheckBox lowCheck = null;
    private JCheckBox middleCheck = null;
    private JCheckBox highCheck = null;
    private JPanel editorPanel = null;

    @Override
    protected Component getEditorComponent(Object value) {
        String data = value == null ? "" : value.toString();
        this.getLowCheck().setSelected(data.contains(LOW));
        this.getMiddleCheck().setSelected(data.contains(MIDDLE));
        this.getHighCheck().setSelected(data.contains(HIGH));
        return this.getEditorPanel();
    }

    private JPanel getEditorPanel() {
        if (this.editorPanel == null) {
            this.editorPanel = new JPanel();
            this.editorPanel.setLayout(new BoxLayout(this.editorPanel, 1));
            this.editorPanel.add(this.getLowCheck());
            this.editorPanel.add(this.getMiddleCheck());
            this.editorPanel.add(this.getHighCheck());
            this.editorPanel.setOpaque(false);
        }
        return this.editorPanel;
    }

    private JCheckBox getLowCheck() {
        if (this.lowCheck == null) {
            this.lowCheck = new JCheckBox("Low (C1-6)");
            this.lowCheck.setOpaque(false);
        }
        return this.lowCheck;
    }

    private JCheckBox getMiddleCheck() {
        if (this.middleCheck == null) {
            this.middleCheck = new JCheckBox("Middle (C7-10)");
            this.middleCheck.setOpaque(false);
        }
        return this.middleCheck;
    }

    private JCheckBox getHighCheck() {
        if (this.highCheck == null) {
            this.highCheck = new JCheckBox("High (C11-)");
            this.highCheck.setOpaque(false);
        }
        return this.highCheck;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.getLowCheck().isSelected() || this.getMiddleCheck().isSelected() || this.getHighCheck().isSelected()) {
            StringBuffer buffer = new StringBuffer();
            if (this.getLowCheck().isSelected()) {
                buffer.append(LOW);
            }
            if (this.getMiddleCheck().isSelected()) {
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                buffer.append(MIDDLE);
            }
            if (this.getHighCheck().isSelected()) {
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                buffer.append(HIGH);
            }
            this.value = buffer.toString();
        } else {
            this.value = null;
        }
        return this.value;
    }

    @Override
    protected String getUserFriendlyValue(Object value) {
        String data = value == null ? "" : value.toString();
        StringBuffer buffer = new StringBuffer();
        if (data.contains(LOW)) {
            buffer.append(this.getLowCheck().getText());
        }
        if (data.contains(MIDDLE)) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getMiddleCheck().getText());
        }
        if (data.contains(HIGH)) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getHighCheck().getText());
        }
        if (buffer.length() == 0) {
            buffer.append("Not specified");
        }
        return buffer.toString();
    }
}

