/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.attachdatadialog;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.sketch.AtomPO;
import chemaxon.marvin.sketch.BondPO;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.sketch.swing.AttachDataDialog;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.attachdatadialog.config.ConfigProvider;
import chemaxon.marvin.sketch.swing.modules.attachdatadialog.config.Context;
import chemaxon.marvin.sketch.swing.modules.attachdatadialog.config.Name;
import chemaxon.marvin.uif.util.swing.AbstractDialog;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MRectanglePoint;
import chemaxon.struc.sgroup.DataSgroup;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class AttachDataDialogImpl
extends AbstractDialog
implements AttachDataDialog {
    private static final long serialVersionUID = 1L;
    private ResourceBundle bundle;
    private static final String[] QUERYVALUES = new String[]{"none", "<", ">", "<=", ">=", "<>", "between", "like", "contains", "="};
    private static final String CONFIGFILENAME = "AttachDataDialog.xml";
    private static ConfigProvider config = new ConfigProvider("AttachDataDialog.xml");
    private SketchPanel sketchPanel;
    private JComboBox contextCombo;
    private JComboBox fieldNameCombo;
    private JTable fieldValueTable;
    private JComboBox queryCombo;
    private JComboBox unitsCombo;
    private JTextField tagTextField;
    private JRadioButton absPlButton;
    private JRadioButton relPlButton;
    private JRadioButton attPlButton;
    private JCheckBox dispUnitsChBox;
    private JTextField dispLinesTextField;
    private JTextField dispCharsTextField;
    private DataSgroup group = null;
    private Object object;
    private int editorAction;
    private ActionListener defaultActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AttachDataDialogImpl.this.validateDialog();
        }
    };
    private KeyListener defaultKeyListener = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            AttachDataDialogImpl.this.validateDialog();
        }
    };
    private ItemListener contextItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                String contextname = e.getItem().toString();
                AttachDataDialogImpl.this.contextActivated(contextname);
            }
        }
    };
    private ItemListener fieldNameItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                String fieldname = e.getItem().toString();
                AttachDataDialogImpl.this.nameActivated(fieldname);
            }
        }
    };

    public AttachDataDialogImpl(Dialog dialog, SketchPanel sketchPanel) {
        super((Window)dialog, "", false);
        this.sketchPanel = sketchPanel;
        this.init();
    }

    public AttachDataDialogImpl(Frame frame, SketchPanel sketchPanel) {
        super((Window)frame, "", false);
        this.sketchPanel = sketchPanel;
        this.init();
    }

    private void init() {
        this.bundle = MolPanel.getResourceBundle(this.getClass().getName());
        this.setTitle(this.bundle.getString("title"));
    }

    @Override
    protected JComponent buildButtonBar() {
        return this.buildOKCancelButtonBar();
    }

    @Override
    protected JComponent buildContentPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.PREF_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)20)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.PREF_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(pref;20dlu)")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 0.0), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 0.0), FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0), FormFactory.UNRELATED_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 1.0)}));
        CellConstraints cc = new CellConstraints();
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.createFieldPanel(contentPane, cc, compFactory);
        this.createAppearancePanel(contentPane, cc, compFactory);
        this.fillControls();
        return contentPane;
    }

    @Override
    public DataSgroup getDataSgroup() {
        return this.group;
    }

    @Override
    public void setDataSgroup(DataSgroup g) {
        this.group = g;
    }

    @Override
    public void setSelection(Object o) {
        this.object = o;
    }

    @Override
    public void setEditorAction(int i) {
        this.editorAction = i;
    }

    private String fillValues() {
        String fieldName = (String)this.fieldNameCombo.getSelectedItem();
        Context c = config.getContextByDisplayName((String)this.contextCombo.getSelectedItem());
        if (c != null && !c.containsName(fieldName)) {
            c.addDataName(new Name(fieldName));
        }
        Vector<String> dataVec = new Vector<String>();
        int[] selcols = this.fieldValueTable.getSelectedRows();
        for (int i = 0; i < selcols.length; ++i) {
            String selected = (String)this.fieldValueTable.getModel().getValueAt(selcols[i], 0);
            dataVec.add(selected);
            if (c == null || c.getDataName(fieldName).getValues().contains(selected)) continue;
            c.getDataName(fieldName).addValue(selected);
        }
        String unit = (String)this.unitsCombo.getSelectedItem();
        if (unit != null && c != null && c.getDataName(fieldName) != null && !c.getDataName(fieldName).getUnits().contains(unit)) {
            c.getDataName(fieldName).addUnit(unit);
        }
        StringBuffer sb = new StringBuffer(300);
        sb.append('\u9999');
        sb.append(this.absPlButton.isSelected());
        sb.append('\u9999');
        sb.append(this.glueData(dataVec));
        sb.append('\u9999');
        sb.append(!this.attPlButton.isSelected() || !this.contextCombo.getSelectedItem().toString().equals("Atom"));
        sb.append('\u9999');
        String text = this.dispCharsTextField.getText();
        String all = this.bundle.getString("dispAllValue");
        sb.append(text.equalsIgnoreCase(all) ? 0 : Integer.parseInt(text));
        sb.append('\u9999');
        text = this.dispLinesTextField.getText();
        sb.append(text.equalsIgnoreCase(all) ? 0 : Integer.parseInt(text));
        sb.append('\u9999');
        sb.append(fieldName);
        sb.append('\u9999');
        String queryOp = (String)this.queryCombo.getSelectedItem();
        sb.append(queryOp.equals("none") ? "none" : "mQ");
        sb.append('\u9999');
        sb.append(queryOp);
        sb.append('\u9999');
        text = this.tagTextField.getText();
        sb.append(text.length() == 0 ? (char)' ' : text.charAt(0));
        sb.append('\u9999');
        sb.append(this.dispUnitsChBox.isSelected());
        sb.append('\u9999');
        sb.append(unit == null || unit.length() == 0 ? "\u9998" : unit);
        sb.append('\u9999');
        sb.append(c != null ? c.getName() : this.contextCombo.getSelectedItem());
        return sb.toString();
    }

    private void fillControls() {
        if (this.group == null) {
            this.fieldNameCombo.setSelectedIndex(0);
            if (this.fieldNameCombo.isEditable()) {
                this.fieldNameCombo.getEditor().selectAll();
            }
            ((DefaultTableModel)this.fieldValueTable.getModel()).setColumnCount(0);
            ((DefaultTableModel)this.fieldValueTable.getModel()).addColumn(null, new String[]{""});
            this.queryCombo.setSelectedIndex(0);
            this.unitsCombo.setSelectedIndex(0);
            this.tagTextField.setText("");
            this.relPlButton.setSelected(false);
            this.attPlButton.setSelected(false);
            this.absPlButton.setSelected(true);
            this.dispUnitsChBox.setSelected(true);
            this.dispLinesTextField.setText(this.bundle.getString("dispAllValue"));
            this.dispCharsTextField.setText(this.bundle.getString("dispAllValue"));
            this.nameActivated(this.fieldNameCombo.getItemAt(0).toString());
            return;
        }
        Context c = config.getContext(this.group.getContext());
        if (c == null) {
            c = config.getContextByDisplayName(this.group.getContext());
        }
        if (c == null) {
            c = config.getContextByFieldName(this.group.getFieldName());
        }
        if (c == null) {
            c = config.getDefaultContext();
        }
        this.contextActivated(c.getDisplayName());
        this.contextCombo.setSelectedItem(c.getDisplayName());
        if (!c.containsName(this.group.getFieldName())) {
            c.addDataName(new Name(this.group.getFieldName()));
        }
        Vector<String> data = this.parseLines(this.group.getData());
        for (String d : data) {
            if (c.getDataName(this.group.getFieldName()).getValues().contains(d)) continue;
            c.getDataName(this.group.getFieldName()).addValue(d);
        }
        this.fieldNameCombo.setSelectedItem(this.group.getFieldName());
        this.fieldNameCombo.getEditor().selectAll();
        this.nameActivated(this.fieldNameCombo.getSelectedItem().toString());
        for (int i = 0; i < data.size(); ++i) {
            int idx;
            for (idx = -1; idx < this.fieldValueTable.getRowCount() && !data.get(i).equals(this.fieldValueTable.getValueAt(idx + 1, 0)); ++idx) {
            }
            if (-1 >= idx || idx + 1 > this.fieldValueTable.getRowCount()) continue;
            this.fieldValueTable.getSelectionModel().addSelectionInterval(idx + 1, idx + 1);
        }
        if (this.group.getQueryOp() != null) {
            this.queryCombo.setSelectedItem(this.group.getQueryOp());
        } else {
            this.queryCombo.setSelectedIndex(0);
        }
        if (this.group.getUnits() != null) {
            if (!c.getDataName(this.group.getFieldName()).getUnits().contains(this.group.getUnits())) {
                c.getDataName(this.group.getFieldName()).addUnit(this.group.getUnits());
            }
            this.unitsCombo.setSelectedItem(this.group.getUnits());
        } else {
            this.unitsCombo.setSelectedIndex(0);
        }
        this.tagTextField.setText(String.valueOf(this.group.getTag()));
        this.relPlButton.setSelected(this.group.isDataDetached() && !this.group.isAbsolutePlacement());
        this.attPlButton.setSelected(!this.group.isDataDetached());
        this.absPlButton.setSelected(this.group.isDataDetached() && this.group.isAbsolutePlacement());
        this.dispUnitsChBox.setSelected(this.group.isUnitDisplayed());
        if (this.group.getDisplayedLines() == 0) {
            this.dispLinesTextField.setText(this.bundle.getString("dispAllValue"));
        } else {
            this.dispLinesTextField.setText(String.valueOf(this.group.getDisplayedLines()));
        }
        if (this.group.getDisplayedChars() == 0) {
            this.dispCharsTextField.setText(this.bundle.getString("dispAllValue"));
        } else {
            this.dispCharsTextField.setText(String.valueOf(this.group.getDisplayedChars()));
        }
        this.validateDialog();
    }

    private void validateDialog() {
        this.getOKAction().setEnabled(this.isValidDialog());
    }

    private void createFieldPanel(JPanel contentPanel, CellConstraints cc, DefaultComponentFactory compFactory) {
        Name n;
        JComponent fieldSeparator = compFactory.createSeparator(this.bundle.getString("fieldLabel"));
        contentPanel.add((Component)fieldSeparator, cc.xywh(1, 1, 5, 1));
        JLabel contextLabel = new JLabel(this.bundle.getString("contextLabel"));
        contentPanel.add((Component)contextLabel, cc.xy(1, 3));
        this.contextCombo = new JComboBox<Object>(config.getContextNames().toArray());
        String detectedContextName = this.detectContext();
        Context detectedContext = config.getContext(detectedContextName);
        if (detectedContext == null) {
            detectedContext = config.getDefaultContext();
        }
        this.contextCombo.setSelectedItem(detectedContext != null ? detectedContext.getDisplayName() : null);
        this.contextCombo.setEditable(false);
        this.contextCombo.addActionListener(this.defaultActionListener);
        this.contextCombo.addItemListener(this.contextItemListener);
        contentPanel.add((Component)this.contextCombo, cc.xywh(3, 3, 3, 1));
        JLabel jLabel = new JLabel(this.bundle.getString("nameLabel"));
        contentPanel.add((Component)jLabel, cc.xy(1, 5));
        Context c = config.getContextByDisplayName(this.contextCombo.getSelectedItem().toString());
        Vector<String> emptyVec = new Vector<String>();
        if (c == null || c.isNameFieldEditable()) {
            emptyVec.add("");
        }
        this.fieldNameCombo = new JComboBox(c != null ? new Vector<String>(c.getDataNames()) : emptyVec);
        this.fieldNameCombo.setEditable(c != null ? c.isNameFieldEditable() : true);
        this.fieldNameCombo.addActionListener(this.defaultActionListener);
        this.fieldNameCombo.getEditor().getEditorComponent().addKeyListener(this.defaultKeyListener);
        this.fieldNameCombo.addItemListener(this.fieldNameItemListener);
        this.fieldNameCombo.setSelectedIndex(0);
        contentPanel.add((Component)this.fieldNameCombo, cc.xywh(3, 5, 3, 1));
        JLabel label2 = new JLabel(this.bundle.getString("valueLabel"));
        contentPanel.add((Component)label2, cc.xywh(1, 7, 3, 9, CellConstraints.LEFT, CellConstraints.TOP));
        Name name = n = c != null ? c.getDataName((String)this.fieldNameCombo.getSelectedItem()) : null;
        if (emptyVec.isEmpty() && (n == null || n.isValueFieldEditable())) {
            emptyVec.add("");
        }
        Vector<String> valueVec = n != null ? new Vector<String>(n.getValues()) : emptyVec;
        this.fieldValueTable = new JTable();
        DefaultTableModel valueModel = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return row == 0 && (n == null || n.isValueFieldEditable());
            }
        };
        valueModel.addColumn(null, valueVec);
        this.fieldValueTable.setModel(valueModel);
        this.fieldValueTable.setShowGrid(false);
        this.fieldValueTable.setTableHeader(null);
        this.fieldValueTable.setPreferredScrollableViewportSize(new Dimension(200, 100));
        this.fieldValueTable.setSelectionMode(n != null && n.isMultipleSelect() ? 2 : 0);
        this.fieldValueTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AttachDataDialogImpl.this.validateDialog();
            }
        });
        this.fieldValueTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 0 && e.getFirstRow() == 0) {
                    DefaultTableModel model = (DefaultTableModel)e.getSource();
                    model.insertRow(0, new Vector());
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.fieldValueTable);
        scrollPane.setVerticalScrollBarPolicy(22);
        contentPanel.add((Component)scrollPane, cc.xywh(3, 7, 3, 9));
        JLabel label3 = new JLabel(this.bundle.getString("queryLabel"));
        contentPanel.add((Component)label3, cc.xy(1, 17));
        Vector<String> qV = new Vector<String>(QUERYVALUES.length);
        qV.addAll(Arrays.asList(QUERYVALUES));
        this.queryCombo = new JComboBox(qV);
        contentPanel.add((Component)this.queryCombo, cc.xywh(3, 17, 3, 1));
        JLabel label4 = new JLabel(this.bundle.getString("unitsLabel"));
        contentPanel.add((Component)label4, cc.xy(1, 19));
        this.unitsCombo = new JComboBox(n != null ? new Vector<String>(n.getUnits()) : emptyVec);
        this.unitsCombo.setEditable(true);
        contentPanel.add((Component)this.unitsCombo, cc.xywh(3, 19, 3, 1));
        JLabel label5 = new JLabel(this.bundle.getString("tagLabel"));
        contentPanel.add((Component)label5, cc.xy(1, 21));
        this.tagTextField = new JTextField(1);
        this.tagTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char pressed = e.getKeyChar();
                if (pressed != '\b' && pressed != '\u007f' && pressed != '\n' && pressed != '\t' && AttachDataDialogImpl.this.tagTextField.getText().length() != 0) {
                    e.consume();
                }
            }
        });
        contentPanel.add((Component)this.tagTextField, cc.xy(3, 21));
    }

    private String detectContext() {
        PointedObject po = this.sketchPanel.getEditor().getPointedObject();
        if (po != null) {
            if (po instanceof AtomPO) {
                return "Atom";
            }
            if (po instanceof BondPO) {
                int type = ((BondPO)po).getBond().getType();
                if (type == 1) {
                    return "Single Bond";
                }
                if (type == 2) {
                    return "Double Bond";
                }
                return "Bond";
            }
        } else if (this.object != null) {
            if (this.object instanceof MolAtom) {
                return "Atom";
            }
            if (this.object instanceof MolBond) {
                int type = ((MolBond)this.object).getType();
                if (type == 1) {
                    return "Single Bond";
                }
                if (type == 2) {
                    return "Double Bond";
                }
                return "Bond";
            }
        } else {
            SelectionMolecule sel = this.sketchPanel.getEditor().getSelectionMolecule();
            MolBond[] bonds = sel.getBondArray();
            boolean selContainsOnlyFullFrags = true;
            for (int i = 0; i < bonds.length && selContainsOnlyFullFrags; ++i) {
                int j;
                if (!sel.contains(bonds[i].getAtom1()) || !sel.contains(bonds[i].getAtom2())) {
                    selContainsOnlyFullFrags = false;
                }
                for (j = 0; j < bonds[i].getAtom1().getBondCount(); ++j) {
                    if (sel.contains(bonds[i].getAtom1().getBond(j))) continue;
                    selContainsOnlyFullFrags = false;
                }
                for (j = 0; j < bonds[i].getAtom2().getBondCount(); ++j) {
                    if (sel.contains(bonds[i].getAtom2().getBond(j))) continue;
                    selContainsOnlyFullFrags = false;
                }
            }
            if (selContainsOnlyFullFrags) {
                MolAtom[] atoms = sel.getAtomArray();
                for (int i = 0; i < atoms.length && selContainsOnlyFullFrags; ++i) {
                    for (int j = 0; j < atoms[i].getBondCount(); ++j) {
                        if (sel.contains(atoms[i].getBond(j))) continue;
                        selContainsOnlyFullFrags = false;
                    }
                }
            }
            if (selContainsOnlyFullFrags) {
                return "Fragment";
            }
        }
        return "Group (Selection)";
    }

    private void createAppearancePanel(JPanel contentPanel, CellConstraints cc, DefaultComponentFactory compFactory) {
        this.createPlacementBox(contentPanel, cc, compFactory);
        this.createDisplayBox(contentPanel, cc, compFactory);
    }

    private void createDisplayBox(JPanel contentPanel, CellConstraints cc, DefaultComponentFactory compFactory) {
        JComponent displaySeparator = compFactory.createSeparator(this.bundle.getString("displayLabel"));
        contentPanel.add((Component)displaySeparator, cc.xywh(7, 9, 3, 1));
        this.dispUnitsChBox = new JCheckBox(this.bundle.getString("dUnitsLabel"));
        this.dispUnitsChBox.setSelected(true);
        this.dispUnitsChBox.addKeyListener(this.defaultKeyListener);
        contentPanel.add((Component)this.dispUnitsChBox, cc.xy(7, 15));
        JLabel label6 = new JLabel(this.bundle.getString("dispLinesLabel"));
        contentPanel.add((Component)label6, cc.xy(7, 11));
        this.dispLinesTextField = new JTextField(this.bundle.getString("dispAllValue"));
        this.dispLinesTextField.addKeyListener(this.defaultKeyListener);
        contentPanel.add((Component)this.dispLinesTextField, cc.xy(9, 11));
        JLabel label7 = new JLabel(this.bundle.getString("dispCharsLabel"));
        contentPanel.add((Component)label7, cc.xy(7, 13));
        this.dispCharsTextField = new JTextField(this.bundle.getString("dispAllValue"));
        this.dispCharsTextField.addKeyListener(this.defaultKeyListener);
        contentPanel.add((Component)this.dispCharsTextField, cc.xy(9, 13));
    }

    private void createPlacementBox(JPanel contentPanel, CellConstraints cc, DefaultComponentFactory compFactory) {
        JComponent placementSeparator = compFactory.createSeparator(this.bundle.getString("placementLabel"));
        contentPanel.add((Component)placementSeparator, cc.xywh(7, 1, 3, 1));
        this.absPlButton = new JRadioButton(this.bundle.getString("absolutePlLabel"));
        this.absPlButton.setSelected(true);
        this.absPlButton.setFocusable(false);
        contentPanel.add((Component)this.absPlButton, cc.xy(7, 3));
        this.relPlButton = new JRadioButton(this.bundle.getString("relativePlLabel"));
        this.relPlButton.setFocusable(false);
        contentPanel.add((Component)this.relPlButton, cc.xy(7, 5));
        this.attPlButton = new JRadioButton(this.bundle.getString("attachedPlLabel"));
        this.attPlButton.setFocusable(false);
        contentPanel.add((Component)this.attPlButton, cc.xy(7, 7));
        ButtonGroup buttgroup = new ButtonGroup();
        buttgroup.add(this.absPlButton);
        buttgroup.add(this.relPlButton);
        buttgroup.add(this.attPlButton);
    }

    @Override
    public void apply() {
        MolBond bond;
        TableCellEditor editor = this.fieldValueTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        MolEditor medit = this.sketchPanel.getEditor();
        if (this.object != null && (this.object instanceof MBracket || this.object instanceof MRectanglePoint)) {
            Object bracketObj = this.object instanceof MBracket ? this.object : ((MRectanglePoint)this.object).getParentRect();
            Sgroup psgroup = medit.findContainingSgroup((MBracket)bracketObj);
            Molecule pmol = psgroup.getParentMolecule();
            this.group = new DataSgroup(pmol);
            pmol.addSgroup(this.group, true);
            psgroup.addChildSgroup(this.group);
        } else if (this.object instanceof MolAtom) {
            MolAtom atom = (MolAtom)this.object;
            if (atom.getParent().isMolecule()) {
                Molecule pmol = (Molecule)atom.getParent();
                this.group = new DataSgroup(pmol);
                medit.addToSgroupHierarchy(this.group.getParentMolecule(), this.group, null);
                pmol.setSgroupParent(atom, this.group, true);
                this.group.setAbsoluteXY(this.calcDataSgroupTextPosition(atom));
            }
        } else if (this.object instanceof MolBond && (bond = (MolBond)this.object).getParent().isMolecule()) {
            Molecule pmol = (Molecule)bond.getParent();
            this.group = new DataSgroup(pmol);
            MolAtom atom1 = bond.getAtom1();
            medit.addToSgroupHierarchy(this.group.getParentMolecule(), this.group, null);
            pmol.setSgroupParent(atom1, this.group, true);
            pmol.setSgroupParent(bond.getAtom2(), this.group, true);
            this.group.setAbsoluteXY(this.calcDataSgroupTextPosition(atom1));
        }
        String values = this.fillValues();
        medit.setDataSgroupLabelMoving(false);
        medit.setDataSgroupObject(this.group);
        medit.edit(this.editorAction, values);
        medit.setDataSgroupLabelMoving(false);
        medit.setDataSgroupObject(null);
        this.object = null;
        this.sketchPanel.doSetSelectionMove(-1);
    }

    private DPoint3 calcDataSgroupTextPosition(MolAtom atom) {
        int i = -1;
        if (atom.getParent().isMolecule()) {
            Sgroup[] sgs;
            Molecule m = (Molecule)atom.getParent();
            for (Sgroup s : sgs = m.findAllSgroupContaining(atom)) {
                DataSgroup dsg;
                if (!(s instanceof DataSgroup) || !(dsg = (DataSgroup)s).isDataDetached()) continue;
                ++i;
            }
        }
        return new DPoint3(atom.getLocation().x + 0.77, atom.getLocation().y + 0.77 - (double)i * 0.77, atom.getLocation().z + 0.77);
    }

    private boolean isValidDialog() {
        String all;
        String fieldName = (String)this.fieldNameCombo.getSelectedItem();
        if (fieldName == null || fieldName.length() == 0) {
            return false;
        }
        if (this.fieldValueTable == null || this.fieldValueTable.getSelectedColumnCount() == 0 && this.fieldValueTable.getSelectedRowCount() == 0) {
            return false;
        }
        String text = this.dispCharsTextField.getText();
        if (!text.equalsIgnoreCase(all = this.bundle.getString("dispAllValue"))) {
            try {
                Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (!(text = this.dispLinesTextField.getText()).equalsIgnoreCase(all)) {
            try {
                Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    private void contextActivated(String name) {
        Context context = config.getContextByDisplayName(name);
        this.fieldNameCombo.removeAllItems();
        DefaultTableModel model = (DefaultTableModel)this.fieldValueTable.getModel();
        model.setColumnCount(0);
        this.unitsCombo.removeAllItems();
        this.tagTextField.setText("");
        List<String> fieldNames = context.getDataNames();
        Iterator<String> it = fieldNames.iterator();
        while (it.hasNext()) {
            this.fieldNameCombo.addItem(it.next());
        }
        this.fieldNameCombo.setEditable(context.isNameFieldEditable());
    }

    private void nameActivated(String name) {
        Vector<String> vec;
        Context context = config.getContextByDisplayName((String)this.contextCombo.getSelectedItem());
        final Name dataName = context.getDataName(name);
        DefaultTableModel model = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return row == 0 && (dataName == null || dataName.isValueFieldEditable());
            }
        };
        this.fieldValueTable.setModel(model);
        model.setColumnCount(0);
        this.unitsCombo.removeAllItems();
        this.tagTextField.setText("");
        if (dataName != null) {
            vec = new Vector<String>(dataName.getValues());
            this.fieldValueTable.setSelectionMode(dataName.isMultipleSelect() ? 2 : 0);
            Iterator<String> it = dataName.getUnits().iterator();
            while (it.hasNext()) {
                this.unitsCombo.addItem(it.next());
            }
            this.tagTextField.setText(dataName.getDefaultTag());
        } else {
            vec = new Vector<String>();
            vec.add("");
            this.unitsCombo.addItem("");
        }
        model.addColumn(null, vec);
    }

    private String glueData(Vector<String> dataLines) {
        if (dataLines.size() == 0) {
            return "";
        }
        if (dataLines.size() == 1) {
            return dataLines.elementAt(0);
        }
        StringBuffer sb = new StringBuffer(dataLines.size() * 50);
        for (int i = 0; i < dataLines.size(); ++i) {
            String s = dataLines.elementAt(i);
            sb.append(s);
            sb.append('\n');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private Vector<String> parseLines(String s) {
        Vector<String> dataLines = new Vector<String>();
        int bol = 0;
        int eol = s.indexOf(10, bol);
        while (eol != -1) {
            dataLines.addElement(s.substring(bol, eol));
            bol = eol + 1;
            eol = s.indexOf(10, bol);
        }
        eol = s.length();
        dataLines.addElement(s.substring(bol, eol));
        return dataLines;
    }
}

