/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.attachdatadialog.config;

import chemaxon.marvin.sketch.swing.modules.attachdatadialog.config.Name;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Context {
    private String contextName;
    private String displayName;
    private boolean isNameEditable;
    private List<Name> nameList;

    public Context() {
        this("");
    }

    public Context(String name) {
        this(name, null);
    }

    public Context(String name, List<Name> list) {
        this(name, name, list);
    }

    public Context(String name, String dispname, List<Name> list) {
        this.contextName = name;
        this.isNameEditable = true;
        this.displayName = dispname;
        if (list != null) {
            this.nameList = list;
        } else {
            this.nameList = new ArrayList<Name>();
            this.nameList.add(new Name());
        }
    }

    public String getName() {
        return this.contextName;
    }

    public void setName(String name) {
        this.contextName = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String dispname) {
        this.displayName = dispname;
    }

    public void setNameFieldEditable(boolean isEditable) {
        this.isNameEditable = isEditable;
        if (isEditable) {
            if (this.nameList.get(0) == null || !this.nameList.get(0).getTextRepresentation().equals("")) {
                this.nameList.add(0, new Name(""));
            }
        } else if (this.nameList.get(0) != null && this.nameList.get(0).getTextRepresentation().equals("")) {
            this.nameList.remove(0);
        }
    }

    public boolean isNameFieldEditable() {
        return this.isNameEditable;
    }

    public void addDataName(Name n) {
        this.nameList.add(n);
    }

    public boolean containsName(String textRepresentation) {
        return this.getDataName(textRepresentation) != null;
    }

    public Name getDataName(String textRepresentation) {
        for (Name n : this.nameList) {
            if (!n.getTextRepresentation().equals(textRepresentation)) continue;
            return n;
        }
        return null;
    }

    public List<String> getDataNames() {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator<Name> it = this.nameList.iterator();
        while (it.hasNext()) {
            ret.add(it.next().getTextRepresentation());
        }
        return ret;
    }
}

